package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.CommentId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCommentRequest(commentId: CommentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommentRequest = {
    import GetCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommentRequest
      .builder()
      .commentId(CommentId.unwrap(commentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetCommentRequest.ReadOnly =
    zio.aws.codecommit.model.GetCommentRequest.wrap(buildAwsValue())
}
object GetCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommentRequest =
      zio.aws.codecommit.model.GetCommentRequest(commentId)
    def commentId: CommentId
    def getCommentId: ZIO[Any, Nothing, CommentId] = ZIO.succeed(commentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentRequest
  ) extends zio.aws.codecommit.model.GetCommentRequest.ReadOnly {
    override val commentId: CommentId =
      zio.aws.codecommit.model.primitives.CommentId(impl.commentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommentRequest
  ): zio.aws.codecommit.model.GetCommentRequest.ReadOnly = new Wrapper(impl)
}
