package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  CommitId,
  KeepEmptyFolders,
  Message,
  RepositoryName,
  Email,
  Name,
  BranchName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCommitRequest(
    repositoryName: RepositoryName,
    branchName: BranchName,
    parentCommitId: Option[CommitId] = None,
    authorName: Option[Name] = None,
    email: Option[Email] = None,
    commitMessage: Option[Message] = None,
    keepEmptyFolders: Option[KeepEmptyFolders] = None,
    putFiles: Option[Iterable[zio.aws.codecommit.model.PutFileEntry]] = None,
    deleteFiles: Option[Iterable[zio.aws.codecommit.model.DeleteFileEntry]] =
      None,
    setFileModes: Option[Iterable[zio.aws.codecommit.model.SetFileModeEntry]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.CreateCommitRequest = {
    import CreateCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .branchName(BranchName.unwrap(branchName): java.lang.String)
      .optionallyWith(
        parentCommitId.map(value => CommitId.unwrap(value): java.lang.String)
      )(_.parentCommitId)
      .optionallyWith(
        authorName.map(value => Name.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        commitMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.commitMessage)
      .optionallyWith(
        keepEmptyFolders.map(value =>
          KeepEmptyFolders.unwrap(value): java.lang.Boolean
        )
      )(_.keepEmptyFolders)
      .optionallyWith(
        putFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.putFiles)
      .optionallyWith(
        deleteFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deleteFiles)
      .optionallyWith(
        setFileModes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.setFileModes)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.CreateCommitRequest.ReadOnly =
    zio.aws.codecommit.model.CreateCommitRequest.wrap(buildAwsValue())
}
object CreateCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.CreateCommitRequest =
      zio.aws.codecommit.model.CreateCommitRequest(
        repositoryName,
        branchName,
        parentCommitId.map(value => value),
        authorName.map(value => value),
        email.map(value => value),
        commitMessage.map(value => value),
        keepEmptyFolders.map(value => value),
        putFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        deleteFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        setFileModes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def repositoryName: RepositoryName
    def branchName: BranchName
    def parentCommitId: Option[CommitId]
    def authorName: Option[Name]
    def email: Option[Email]
    def commitMessage: Option[Message]
    def keepEmptyFolders: Option[KeepEmptyFolders]
    def putFiles: Option[List[zio.aws.codecommit.model.PutFileEntry.ReadOnly]]
    def deleteFiles
        : Option[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]]
    def setFileModes
        : Option[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]]
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, Nothing, BranchName] = ZIO.succeed(branchName)
    def getParentCommitId: ZIO[Any, AwsError, CommitId] =
      AwsError.unwrapOptionField("parentCommitId", parentCommitId)
    def getAuthorName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getCommitMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getKeepEmptyFolders: ZIO[Any, AwsError, KeepEmptyFolders] =
      AwsError.unwrapOptionField("keepEmptyFolders", keepEmptyFolders)
    def getPutFiles: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.PutFileEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("putFiles", putFiles)
    def getDeleteFiles: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.DeleteFileEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("deleteFiles", deleteFiles)
    def getSetFileModes: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.SetFileModeEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("setFileModes", setFileModes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ) extends zio.aws.codecommit.model.CreateCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val branchName: BranchName =
      zio.aws.codecommit.model.primitives.BranchName(impl.branchName())
    override val parentCommitId: Option[CommitId] = scala
      .Option(impl.parentCommitId())
      .map(value => zio.aws.codecommit.model.primitives.CommitId(value))
    override val authorName: Option[Name] = scala
      .Option(impl.authorName())
      .map(value => zio.aws.codecommit.model.primitives.Name(value))
    override val email: Option[Email] = scala
      .Option(impl.email())
      .map(value => zio.aws.codecommit.model.primitives.Email(value))
    override val commitMessage: Option[Message] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.codecommit.model.primitives.Message(value))
    override val keepEmptyFolders: Option[KeepEmptyFolders] = scala
      .Option(impl.keepEmptyFolders())
      .map(value => zio.aws.codecommit.model.primitives.KeepEmptyFolders(value))
    override val putFiles
        : Option[List[zio.aws.codecommit.model.PutFileEntry.ReadOnly]] = scala
      .Option(impl.putFiles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.PutFileEntry.wrap(item)
        }.toList
      )
    override val deleteFiles
        : Option[List[zio.aws.codecommit.model.DeleteFileEntry.ReadOnly]] =
      scala
        .Option(impl.deleteFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.DeleteFileEntry.wrap(item)
          }.toList
        )
    override val setFileModes
        : Option[List[zio.aws.codecommit.model.SetFileModeEntry.ReadOnly]] =
      scala
        .Option(impl.setFileModes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.SetFileModeEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.CreateCommitRequest
  ): zio.aws.codecommit.model.CreateCommitRequest.ReadOnly = new Wrapper(impl)
}
