package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{
  ClientRequestToken,
  RevisionId,
  Arn,
  PullRequestId,
  Description,
  LastModifiedDate,
  Title,
  CreationDate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PullRequest(
    pullRequestId: Option[PullRequestId] = None,
    title: Option[Title] = None,
    description: Option[Description] = None,
    lastActivityDate: Option[LastModifiedDate] = None,
    creationDate: Option[CreationDate] = None,
    pullRequestStatus: Option[zio.aws.codecommit.model.PullRequestStatusEnum] =
      None,
    authorArn: Option[Arn] = None,
    pullRequestTargets: Option[
      Iterable[zio.aws.codecommit.model.PullRequestTarget]
    ] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    revisionId: Option[RevisionId] = None,
    approvalRules: Option[Iterable[zio.aws.codecommit.model.ApprovalRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.PullRequest = {
    import PullRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.PullRequest
      .builder()
      .optionallyWith(
        pullRequestId.map(value =>
          PullRequestId.unwrap(value): java.lang.String
        )
      )(_.pullRequestId)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastActivityDate.map(value => LastModifiedDate.unwrap(value): Instant)
      )(_.lastActivityDate)
      .optionallyWith(
        creationDate.map(value => CreationDate.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(pullRequestStatus.map(value => value.unwrap))(
        _.pullRequestStatus
      )
      .optionallyWith(
        authorArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.authorArn)
      .optionallyWith(
        pullRequestTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pullRequestTargets)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        revisionId.map(value => RevisionId.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        approvalRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.approvalRules)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.PullRequest.ReadOnly =
    zio.aws.codecommit.model.PullRequest.wrap(buildAwsValue())
}
object PullRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.PullRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.PullRequest =
      zio.aws.codecommit.model.PullRequest(
        pullRequestId.map(value => value),
        title.map(value => value),
        description.map(value => value),
        lastActivityDate.map(value => value),
        creationDate.map(value => value),
        pullRequestStatus.map(value => value),
        authorArn.map(value => value),
        pullRequestTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        revisionId.map(value => value),
        approvalRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pullRequestId: Option[PullRequestId]
    def title: Option[Title]
    def description: Option[Description]
    def lastActivityDate: Option[LastModifiedDate]
    def creationDate: Option[CreationDate]
    def pullRequestStatus
        : Option[zio.aws.codecommit.model.PullRequestStatusEnum]
    def authorArn: Option[Arn]
    def pullRequestTargets
        : Option[List[zio.aws.codecommit.model.PullRequestTarget.ReadOnly]]
    def clientRequestToken: Option[ClientRequestToken]
    def revisionId: Option[RevisionId]
    def approvalRules
        : Option[List[zio.aws.codecommit.model.ApprovalRule.ReadOnly]]
    def getPullRequestId: ZIO[Any, AwsError, PullRequestId] =
      AwsError.unwrapOptionField("pullRequestId", pullRequestId)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastActivityDate: ZIO[Any, AwsError, LastModifiedDate] =
      AwsError.unwrapOptionField("lastActivityDate", lastActivityDate)
    def getCreationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getPullRequestStatus
        : ZIO[Any, AwsError, zio.aws.codecommit.model.PullRequestStatusEnum] =
      AwsError.unwrapOptionField("pullRequestStatus", pullRequestStatus)
    def getAuthorArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("authorArn", authorArn)
    def getPullRequestTargets: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.PullRequestTarget.ReadOnly
    ]] = AwsError.unwrapOptionField("pullRequestTargets", pullRequestTargets)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRevisionId: ZIO[Any, AwsError, RevisionId] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getApprovalRules: ZIO[Any, AwsError, List[
      zio.aws.codecommit.model.ApprovalRule.ReadOnly
    ]] = AwsError.unwrapOptionField("approvalRules", approvalRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequest
  ) extends zio.aws.codecommit.model.PullRequest.ReadOnly {
    override val pullRequestId: Option[PullRequestId] = scala
      .Option(impl.pullRequestId())
      .map(value => zio.aws.codecommit.model.primitives.PullRequestId(value))
    override val title: Option[Title] = scala
      .Option(impl.title())
      .map(value => zio.aws.codecommit.model.primitives.Title(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.codecommit.model.primitives.Description(value))
    override val lastActivityDate: Option[LastModifiedDate] = scala
      .Option(impl.lastActivityDate())
      .map(value => zio.aws.codecommit.model.primitives.LastModifiedDate(value))
    override val creationDate: Option[CreationDate] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.codecommit.model.primitives.CreationDate(value))
    override val pullRequestStatus
        : Option[zio.aws.codecommit.model.PullRequestStatusEnum] = scala
      .Option(impl.pullRequestStatus())
      .map(value => zio.aws.codecommit.model.PullRequestStatusEnum.wrap(value))
    override val authorArn: Option[Arn] = scala
      .Option(impl.authorArn())
      .map(value => zio.aws.codecommit.model.primitives.Arn(value))
    override val pullRequestTargets
        : Option[List[zio.aws.codecommit.model.PullRequestTarget.ReadOnly]] =
      scala
        .Option(impl.pullRequestTargets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecommit.model.PullRequestTarget.wrap(item)
          }.toList
        )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codecommit.model.primitives.ClientRequestToken(value)
      )
    override val revisionId: Option[RevisionId] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.codecommit.model.primitives.RevisionId(value))
    override val approvalRules
        : Option[List[zio.aws.codecommit.model.ApprovalRule.ReadOnly]] = scala
      .Option(impl.approvalRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.ApprovalRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.PullRequest
  ): zio.aws.codecommit.model.PullRequest.ReadOnly = new Wrapper(impl)
}
