package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{NextToken, ApprovalRuleTemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListAssociatedApprovalRuleTemplatesForRepositoryResponse(
    approvalRuleTemplateNames: Option[Iterable[ApprovalRuleTemplateName]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse = {
    import ListAssociatedApprovalRuleTemplatesForRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
      .builder()
      .optionallyWith(
        approvalRuleTemplateNames.map(value =>
          value.map { item =>
            ApprovalRuleTemplateName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvalRuleTemplateNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly =
    zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
      .wrap(buildAwsValue())
}
object ListAssociatedApprovalRuleTemplatesForRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse =
      zio.aws.codecommit.model
        .ListAssociatedApprovalRuleTemplatesForRepositoryResponse(
          approvalRuleTemplateNames.map(value => value),
          nextToken.map(value => value)
        )
    def approvalRuleTemplateNames: Option[List[ApprovalRuleTemplateName]]
    def nextToken: Option[NextToken]
    def getApprovalRuleTemplateNames
        : ZIO[Any, AwsError, List[ApprovalRuleTemplateName]] = AwsError
      .unwrapOptionField("approvalRuleTemplateNames", approvalRuleTemplateNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ) extends zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly {
    override val approvalRuleTemplateNames
        : Option[List[ApprovalRuleTemplateName]] = scala
      .Option(impl.approvalRuleTemplateNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecommit.model.primitives.ApprovalRuleTemplateName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codecommit.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse
  ): zio.aws.codecommit.model.ListAssociatedApprovalRuleTemplatesForRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
