package zio.aws.codecommit.model
import zio.aws.codecommit.model.primitives.{ObjectId, RepositoryName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCommitRequest(
    repositoryName: RepositoryName,
    commitId: ObjectId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecommit.model.GetCommitRequest = {
    import GetCommitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecommit.model.GetCommitRequest
      .builder()
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .commitId(ObjectId.unwrap(commitId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecommit.model.GetCommitRequest.ReadOnly =
    zio.aws.codecommit.model.GetCommitRequest.wrap(buildAwsValue())
}
object GetCommitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecommit.model.GetCommitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecommit.model.GetCommitRequest =
      zio.aws.codecommit.model.GetCommitRequest(repositoryName, commitId)
    def repositoryName: RepositoryName
    def commitId: ObjectId
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getCommitId: ZIO[Any, Nothing, ObjectId] = ZIO.succeed(commitId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommitRequest
  ) extends zio.aws.codecommit.model.GetCommitRequest.ReadOnly {
    override val repositoryName: RepositoryName =
      zio.aws.codecommit.model.primitives.RepositoryName(impl.repositoryName())
    override val commitId: ObjectId =
      zio.aws.codecommit.model.primitives.ObjectId(impl.commitId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecommit.model.GetCommitRequest
  ): zio.aws.codecommit.model.GetCommitRequest.ReadOnly = new Wrapper(impl)
}
