package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListEventLogsRequestMaxResultsInteger,
  ListEventLogsRequestNextTokenString,
  SyntheticTimestamp_date_time,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEventLogsRequest(
    spaceName: NameString,
    startTime: SyntheticTimestamp_date_time,
    endTime: SyntheticTimestamp_date_time,
    eventName: Optional[String] = Optional.Absent,
    nextToken: Optional[ListEventLogsRequestNextTokenString] = Optional.Absent,
    maxResults: Optional[ListEventLogsRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest = {
    import ListEventLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .startTime(SyntheticTimestamp_date_time.unwrap(startTime): Instant)
      .endTime(SyntheticTimestamp_date_time.unwrap(endTime): Instant)
      .optionallyWith(eventName.map(value => value: java.lang.String))(
        _.eventName
      )
      .optionallyWith(
        nextToken.map(value =>
          ListEventLogsRequestNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListEventLogsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListEventLogsRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListEventLogsRequest.wrap(buildAwsValue())
}
object ListEventLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListEventLogsRequest =
      zio.aws.codecatalyst.model.ListEventLogsRequest(
        spaceName,
        startTime,
        endTime,
        eventName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def spaceName: NameString
    def startTime: SyntheticTimestamp_date_time
    def endTime: SyntheticTimestamp_date_time
    def eventName: Optional[String]
    def nextToken: Optional[ListEventLogsRequestNextTokenString]
    def maxResults: Optional[ListEventLogsRequestMaxResultsInteger]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getStartTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(endTime)
    def getEventName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventName", eventName)
    def getNextToken: ZIO[Any, AwsError, ListEventLogsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListEventLogsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest
  ) extends zio.aws.codecatalyst.model.ListEventLogsRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val startTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.startTime())
    override val endTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.endTime())
    override val eventName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventName())
      .map(value => value: String)
    override val nextToken: Optional[ListEventLogsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListEventLogsRequestNextTokenString(value)
        )
    override val maxResults: Optional[ListEventLogsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListEventLogsRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest
  ): zio.aws.codecatalyst.model.ListEventLogsRequest.ReadOnly = new Wrapper(
    impl
  )
}
