package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.ListSpacesRequestNextTokenString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSpacesRequest(
    nextToken: Optional[ListSpacesRequestNextTokenString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest = {
    import ListSpacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value =>
          ListSpacesRequestNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListSpacesRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListSpacesRequest.wrap(buildAwsValue())
}
object ListSpacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListSpacesRequest =
      zio.aws.codecatalyst.model
        .ListSpacesRequest(nextToken.map(value => value))
    def nextToken: Optional[ListSpacesRequestNextTokenString]
    def getNextToken: ZIO[Any, AwsError, ListSpacesRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest
  ) extends zio.aws.codecatalyst.model.ListSpacesRequest.ReadOnly {
    override val nextToken: Optional[ListSpacesRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListSpacesRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest
  ): zio.aws.codecatalyst.model.ListSpacesRequest.ReadOnly = new Wrapper(impl)
}
