package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters.*
sealed trait DevEnvironmentStatus {
  def unwrap
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus
}
object DevEnvironmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus
  ): zio.aws.codecatalyst.model.DevEnvironmentStatus = value match {
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.PENDING
  }
  case object RUNNING extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.RUNNING
  }
  case object STARTING extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STARTING
  }
  case object STOPPING extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STOPPING
  }
  case object STOPPED extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.STOPPED
  }
  case object FAILED extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.FAILED
  }
  case object DELETING extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.DELETING
  }
  case object DELETED extends zio.aws.codecatalyst.model.DevEnvironmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentStatus.DELETED
  }
}
