package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSpaceRequest(name: NameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest = {
    import DeleteSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DeleteSpaceRequest.ReadOnly =
    zio.aws.codecatalyst.model.DeleteSpaceRequest.wrap(buildAwsValue())
}
object DeleteSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DeleteSpaceRequest =
      zio.aws.codecatalyst.model.DeleteSpaceRequest(name)
    def name: NameString
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest
  ) extends zio.aws.codecatalyst.model.DeleteSpaceRequest.ReadOnly {
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest
  ): zio.aws.codecatalyst.model.DeleteSpaceRequest.ReadOnly = new Wrapper(impl)
}
