package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSpaceResponse(
    name: Optional[NameString] = Optional.Absent,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse = {
    import UpdateSpaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse
      .builder()
      .optionallyWith(
        name.map(value => NameString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly =
    zio.aws.codecatalyst.model.UpdateSpaceResponse.wrap(buildAwsValue())
}
object UpdateSpaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateSpaceResponse =
      zio.aws.codecatalyst.model.UpdateSpaceResponse(
        name.map(value => value),
        displayName.map(value => value),
        description.map(value => value)
      )
    def name: Optional[NameString]
    def displayName: Optional[String]
    def description: Optional[String]
    def getName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse
  ) extends zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly {
    override val name: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceResponse
  ): zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly = new Wrapper(impl)
}
