package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListDevEnvironmentSessionsRequestMaxResultsInteger,
  ListDevEnvironmentSessionsRequestNextTokenString,
  Uuid,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDevEnvironmentSessionsRequest(
    spaceName: NameString,
    projectName: NameString,
    devEnvironmentId: Uuid,
    nextToken: Optional[ListDevEnvironmentSessionsRequestNextTokenString] =
      Optional.Absent,
    maxResults: Optional[ListDevEnvironmentSessionsRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest = {
    import ListDevEnvironmentSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .devEnvironmentId(Uuid.unwrap(devEnvironmentId): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ListDevEnvironmentSessionsRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListDevEnvironmentSessionsRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest
      .wrap(buildAwsValue())
}
object ListDevEnvironmentSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest =
      zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest(
        spaceName,
        projectName,
        devEnvironmentId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def devEnvironmentId: Uuid
    def nextToken: Optional[ListDevEnvironmentSessionsRequestNextTokenString]
    def maxResults: Optional[ListDevEnvironmentSessionsRequestMaxResultsInteger]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getDevEnvironmentId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(devEnvironmentId)
    def getNextToken
        : ZIO[Any, AwsError, ListDevEnvironmentSessionsRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListDevEnvironmentSessionsRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
  ) extends zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val devEnvironmentId: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.devEnvironmentId())
    override val nextToken
        : Optional[ListDevEnvironmentSessionsRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListDevEnvironmentSessionsRequestNextTokenString(value)
        )
    override val maxResults
        : Optional[ListDevEnvironmentSessionsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListDevEnvironmentSessionsRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest
  ): zio.aws.codecatalyst.model.ListDevEnvironmentSessionsRequest.ReadOnly =
    new Wrapper(impl)
}
