package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  DevEnvironmentSummaryAliasString,
  StatusReason,
  SyntheticTimestamp_date_time,
  Uuid,
  NameString,
  DevEnvironmentSummaryCreatorIdString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DevEnvironmentSummary(
    spaceName: Optional[NameString] = Optional.Absent,
    projectName: Optional[NameString] = Optional.Absent,
    id: Uuid,
    lastUpdatedTime: SyntheticTimestamp_date_time,
    creatorId: DevEnvironmentSummaryCreatorIdString,
    status: zio.aws.codecatalyst.model.DevEnvironmentStatus,
    statusReason: Optional[StatusReason] = Optional.Absent,
    repositories: Iterable[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary
    ],
    alias: Optional[DevEnvironmentSummaryAliasString] = Optional.Absent,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.Ide]] = Optional.Absent,
    instanceType: zio.aws.codecatalyst.model.InstanceType,
    inactivityTimeoutMinutes: InactivityTimeoutMinutes,
    persistentStorage: zio.aws.codecatalyst.model.PersistentStorage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary = {
    import DevEnvironmentSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary
      .builder()
      .optionallyWith(
        spaceName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.spaceName)
      .optionallyWith(
        projectName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.projectName)
      .id(Uuid.unwrap(id): java.lang.String)
      .lastUpdatedTime(
        SyntheticTimestamp_date_time.unwrap(lastUpdatedTime): Instant
      )
      .creatorId(
        DevEnvironmentSummaryCreatorIdString.unwrap(creatorId): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .repositories(repositories.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        alias.map(value =>
          DevEnvironmentSummaryAliasString.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .instanceType(instanceType.unwrap)
      .inactivityTimeoutMinutes(
        InactivityTimeoutMinutes.unwrap(inactivityTimeoutMinutes): Integer
      )
      .persistentStorage(persistentStorage.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly =
    zio.aws.codecatalyst.model.DevEnvironmentSummary.wrap(buildAwsValue())
}
object DevEnvironmentSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DevEnvironmentSummary =
      zio.aws.codecatalyst.model.DevEnvironmentSummary(
        spaceName.map(value => value),
        projectName.map(value => value),
        id,
        lastUpdatedTime,
        creatorId,
        status,
        statusReason.map(value => value),
        repositories.map { item =>
          item.asEditable
        },
        alias.map(value => value),
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType,
        inactivityTimeoutMinutes,
        persistentStorage.asEditable
      )
    def spaceName: Optional[NameString]
    def projectName: Optional[NameString]
    def id: Uuid
    def lastUpdatedTime: SyntheticTimestamp_date_time
    def creatorId: DevEnvironmentSummaryCreatorIdString
    def status: zio.aws.codecatalyst.model.DevEnvironmentStatus
    def statusReason: Optional[StatusReason]
    def repositories: List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ]
    def alias: Optional[DevEnvironmentSummaryAliasString]
    def ides: Optional[List[zio.aws.codecatalyst.model.Ide.ReadOnly]]
    def instanceType: zio.aws.codecatalyst.model.InstanceType
    def inactivityTimeoutMinutes: InactivityTimeoutMinutes
    def persistentStorage: zio.aws.codecatalyst.model.PersistentStorage.ReadOnly
    def getSpaceName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("spaceName", spaceName)
    def getProjectName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getLastUpdatedTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(lastUpdatedTime)
    def getCreatorId: ZIO[Any, Nothing, DevEnvironmentSummaryCreatorIdString] =
      ZIO.succeed(creatorId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.DevEnvironmentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getRepositories: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ]] = ZIO.succeed(repositories)
    def getAlias: ZIO[Any, AwsError, DevEnvironmentSummaryAliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getIdes
        : ZIO[Any, AwsError, List[zio.aws.codecatalyst.model.Ide.ReadOnly]] =
      AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, Nothing, InactivityTimeoutMinutes] =
      ZIO.succeed(inactivityTimeoutMinutes)
    def getPersistentStorage: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.PersistentStorage.ReadOnly
    ] = ZIO.succeed(persistentStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary
  ) extends zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly {
    override val spaceName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val projectName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val lastUpdatedTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.lastUpdatedTime())
    override val creatorId: DevEnvironmentSummaryCreatorIdString =
      zio.aws.codecatalyst.model.primitives
        .DevEnvironmentSummaryCreatorIdString(impl.creatorId())
    override val status: zio.aws.codecatalyst.model.DevEnvironmentStatus =
      zio.aws.codecatalyst.model.DevEnvironmentStatus.wrap(impl.status())
    override val statusReason: Optional[StatusReason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.codecatalyst.model.primitives.StatusReason(value))
    override val repositories: List[
      zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.ReadOnly
    ] = impl
      .repositories()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.DevEnvironmentRepositorySummary.wrap(item)
      }
      .toList
    override val alias: Optional[DevEnvironmentSummaryAliasString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .DevEnvironmentSummaryAliasString(value)
        )
    override val ides: Optional[List[zio.aws.codecatalyst.model.Ide.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.Ide.wrap(item)
          }.toList
        )
    override val instanceType: zio.aws.codecatalyst.model.InstanceType =
      zio.aws.codecatalyst.model.InstanceType.wrap(impl.instanceType())
    override val inactivityTimeoutMinutes: InactivityTimeoutMinutes =
      zio.aws.codecatalyst.model.primitives
        .InactivityTimeoutMinutes(impl.inactivityTimeoutMinutes())
    override val persistentStorage
        : zio.aws.codecatalyst.model.PersistentStorage.ReadOnly =
      zio.aws.codecatalyst.model.PersistentStorage
        .wrap(impl.persistentStorage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSummary
  ): zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly = new Wrapper(
    impl
  )
}
