package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSourceRepositoryBranchesResponse(
    nextToken: Optional[String] = Optional.Absent,
    items: Iterable[zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse = {
    import ListSourceRepositoryBranchesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse
      .wrap(buildAwsValue())
}
object ListSourceRepositoryBranchesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse =
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse(
        nextToken.map(value => value),
        items.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def items: List[
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val items: List[
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
    ] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesResponse
  ): zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly =
    new Wrapper(impl)
}
