package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryDescriptionString,
  SourceRepositoryNameString,
  NameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSourceRepositoryResponse(
    spaceName: NameString,
    projectName: NameString,
    name: SourceRepositoryNameString,
    description: Optional[SourceRepositoryDescriptionString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse = {
    import CreateSourceRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .name(SourceRepositoryNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SourceRepositoryDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly =
    zio.aws.codecatalyst.model.CreateSourceRepositoryResponse
      .wrap(buildAwsValue())
}
object CreateSourceRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateSourceRepositoryResponse =
      zio.aws.codecatalyst.model.CreateSourceRepositoryResponse(
        spaceName,
        projectName,
        name,
        description.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def name: SourceRepositoryNameString
    def description: Optional[SourceRepositoryDescriptionString]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, SourceRepositoryDescriptionString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse
  ) extends zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val name: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.name())
    override val description: Optional[SourceRepositoryDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryDescriptionString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryResponse
  ): zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly =
    new Wrapper(impl)
}
