package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{ProjectDescription, NameString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    spaceName: NameString,
    name: NameString,
    description: Optional[ProjectDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.UpdateProjectRequest.ReadOnly =
    zio.aws.codecatalyst.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateProjectRequest =
      zio.aws.codecatalyst.model
        .UpdateProjectRequest(spaceName, name, description.map(value => value))
    def spaceName: NameString
    def name: NameString
    def description: Optional[ProjectDescription]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest
  ) extends zio.aws.codecatalyst.model.UpdateProjectRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
    override val description: Optional[ProjectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.ProjectDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest
  ): zio.aws.codecatalyst.model.UpdateProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
