package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  Uuid,
  NameString,
  StartDevEnvironmentSessionResponseSessionIdString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDevEnvironmentSessionResponse(
    accessDetails: zio.aws.codecatalyst.model.DevEnvironmentAccessDetails,
    sessionId: Optional[StartDevEnvironmentSessionResponseSessionIdString] =
      Optional.Absent,
    spaceName: NameString,
    projectName: NameString,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse = {
    import StartDevEnvironmentSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse
      .builder()
      .accessDetails(accessDetails.buildAwsValue())
      .optionallyWith(
        sessionId.map(value =>
          StartDevEnvironmentSessionResponseSessionIdString.unwrap(
            value
          ): java.lang.String
        )
      )(_.sessionId)
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly =
    zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse
      .wrap(buildAwsValue())
}
object StartDevEnvironmentSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse =
      zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse(
        accessDetails.asEditable,
        sessionId.map(value => value),
        spaceName,
        projectName,
        id
      )
    def accessDetails
        : zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly
    def sessionId: Optional[StartDevEnvironmentSessionResponseSessionIdString]
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def getAccessDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly
    ] = ZIO.succeed(accessDetails)
    def getSessionId: ZIO[
      Any,
      AwsError,
      StartDevEnvironmentSessionResponseSessionIdString
    ] = AwsError.unwrapOptionField("sessionId", sessionId)
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse
  ) extends zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly {
    override val accessDetails
        : zio.aws.codecatalyst.model.DevEnvironmentAccessDetails.ReadOnly =
      zio.aws.codecatalyst.model.DevEnvironmentAccessDetails
        .wrap(impl.accessDetails())
    override val sessionId
        : Optional[StartDevEnvironmentSessionResponseSessionIdString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionId())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .StartDevEnvironmentSessionResponseSessionIdString(value)
        )
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionResponse
  ): zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly =
    new Wrapper(impl)
}
