package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryNameString,
  NameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSourceRepositoryRequest(
    spaceName: NameString,
    projectName: NameString,
    name: SourceRepositoryNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest = {
    import GetSourceRepositoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .name(SourceRepositoryNameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.GetSourceRepositoryRequest.ReadOnly =
    zio.aws.codecatalyst.model.GetSourceRepositoryRequest.wrap(buildAwsValue())
}
object GetSourceRepositoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetSourceRepositoryRequest =
      zio.aws.codecatalyst.model
        .GetSourceRepositoryRequest(spaceName, projectName, name)
    def spaceName: NameString
    def projectName: NameString
    def name: SourceRepositoryNameString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest
  ) extends zio.aws.codecatalyst.model.GetSourceRepositoryRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val name: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest
  ): zio.aws.codecatalyst.model.GetSourceRepositoryRequest.ReadOnly =
    new Wrapper(impl)
}
