package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventPayload(
    contentType: Optional[String] = Optional.Absent,
    data: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.EventPayload = {
    import EventPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.EventPayload
      .builder()
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(data.map(value => value: java.lang.String))(_.data)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.EventPayload.ReadOnly =
    zio.aws.codecatalyst.model.EventPayload.wrap(buildAwsValue())
}
object EventPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.EventPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.EventPayload =
      zio.aws.codecatalyst.model
        .EventPayload(contentType.map(value => value), data.map(value => value))
    def contentType: Optional[String]
    def data: Optional[String]
    def getContentType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.EventPayload
  ) extends zio.aws.codecatalyst.model.EventPayload.ReadOnly {
    override val contentType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => value: String)
    override val data: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.EventPayload
  ): zio.aws.codecatalyst.model.EventPayload.ReadOnly = new Wrapper(impl)
}
