package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  ProjectDescription,
  ProjectDisplayName,
  NameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateProjectRequest(
    spaceName: NameString,
    displayName: ProjectDisplayName,
    description: Optional[ProjectDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .displayName(ProjectDisplayName.unwrap(displayName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.CreateProjectRequest.ReadOnly =
    zio.aws.codecatalyst.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateProjectRequest =
      zio.aws.codecatalyst.model.CreateProjectRequest(
        spaceName,
        displayName,
        description.map(value => value)
      )
    def spaceName: NameString
    def displayName: ProjectDisplayName
    def description: Optional[ProjectDescription]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getDisplayName: ZIO[Any, Nothing, ProjectDisplayName] =
      ZIO.succeed(displayName)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest
  ) extends zio.aws.codecatalyst.model.CreateProjectRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val displayName: ProjectDisplayName =
      zio.aws.codecatalyst.model.primitives
        .ProjectDisplayName(impl.displayName())
    override val description: Optional[ProjectDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.ProjectDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest
  ): zio.aws.codecatalyst.model.CreateProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
