package zio.aws.codecatalyst
import software.amazon.awssdk.services.codecatalyst.paginators.{
  ListSourceRepositoryBranchesPublisher,
  ListDevEnvironmentsPublisher,
  ListDevEnvironmentSessionsPublisher,
  ListSourceRepositoriesPublisher,
  ListProjectsPublisher,
  ListEventLogsPublisher,
  ListSpacesPublisher,
  ListAccessTokensPublisher
}
import zio.aws.codecatalyst.model.StartDevEnvironmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.codecatalyst.model.{
  StartDevEnvironmentRequest,
  UpdateDevEnvironmentRequest,
  UpdateSpaceRequest,
  GetSourceRepositoryCloneUrlsRequest,
  GetProjectRequest,
  CreateAccessTokenRequest,
  StartDevEnvironmentSessionRequest,
  ListEventLogsRequest,
  CreateProjectRequest,
  ListDevEnvironmentSessionsRequest,
  GetDevEnvironmentRequest,
  GetSourceRepositoryRequest,
  GetUserDetailsRequest,
  CreateSourceRepositoryBranchRequest,
  ListSourceRepositoriesRequest,
  DeleteSourceRepositoryRequest,
  GetSpaceRequest,
  UpdateProjectRequest,
  DeleteDevEnvironmentRequest,
  StopDevEnvironmentSessionRequest,
  DeleteProjectRequest,
  StopDevEnvironmentRequest,
  ListSpacesRequest,
  ListAccessTokensRequest,
  CreateSourceRepositoryRequest,
  ListProjectsRequest,
  DeleteAccessTokenRequest,
  GetSubscriptionRequest,
  ListSourceRepositoryBranchesRequest,
  ListDevEnvironmentsRequest,
  DeleteSpaceRequest,
  CreateDevEnvironmentRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.codecatalyst.model.{
  DeleteAccessTokenResponse,
  ListSourceRepositoriesResponse,
  UpdateSpaceResponse,
  ListSourceRepositoryBranchesItem,
  DevEnvironmentSessionSummary,
  EventLogEntry,
  DeleteSourceRepositoryResponse,
  ListSourceRepositoriesItem,
  ListProjectsResponse,
  DevEnvironmentSummary,
  CreateAccessTokenResponse,
  SpaceSummary,
  UpdateDevEnvironmentResponse,
  CreateSourceRepositoryResponse,
  VerifySessionResponse,
  GetUserDetailsResponse,
  ListAccessTokensResponse,
  CreateDevEnvironmentResponse,
  CreateProjectResponse,
  DeleteDevEnvironmentResponse,
  GetDevEnvironmentResponse,
  ListDevEnvironmentsResponse,
  ListSpacesResponse,
  ListEventLogsResponse,
  ListDevEnvironmentSessionsResponse,
  AccessTokenSummary,
  ProjectSummary,
  GetSpaceResponse,
  ListSourceRepositoryBranchesResponse,
  StopDevEnvironmentResponse,
  GetSubscriptionResponse,
  StartDevEnvironmentSessionResponse,
  VerifySessionRequest,
  GetSourceRepositoryResponse,
  DeleteSpaceResponse,
  UpdateProjectResponse,
  StopDevEnvironmentSessionResponse,
  DeleteProjectResponse,
  CreateSourceRepositoryBranchResponse,
  GetSourceRepositoryCloneUrlsResponse,
  GetProjectResponse,
  StartDevEnvironmentResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.codecatalyst.{
  CodeCatalystAsyncClientBuilder,
  CodeCatalystAsyncClient
}
import scala.jdk.CollectionConverters.*
trait CodeCatalyst extends AspectSupport[CodeCatalyst] {
  val api: CodeCatalystAsyncClient
  def getSourceRepository(request: GetSourceRepositoryRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly
  ]
  def getProject(
      request: GetProjectRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly]
  def createAccessToken(
      request: CreateAccessTokenRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly]
  def updateDevEnvironment(request: UpdateDevEnvironmentRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly
  ]
  def listDevEnvironmentSessions(
      request: ListDevEnvironmentSessionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
  ]
  def listDevEnvironmentSessionsPaginated(
      request: ListDevEnvironmentSessionsRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly
  ]
  def listSourceRepositories(request: ListSourceRepositoriesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
  ]
  def listSourceRepositoriesPaginated(
      request: ListSourceRepositoriesRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly
  ]
  def updateProject(
      request: UpdateProjectRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly]
  def listAccessTokens(request: ListAccessTokensRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
  ]
  def listAccessTokensPaginated(
      request: ListAccessTokensRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly]
  def getDevEnvironment(
      request: GetDevEnvironmentRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly]
  def listEventLogs(
      request: ListEventLogsRequest
  ): ZStream[Any, AwsError, zio.aws.codecatalyst.model.EventLogEntry.ReadOnly]
  def listEventLogsPaginated(
      request: ListEventLogsRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly]
  def deleteSourceRepository(request: DeleteSourceRepositoryRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.ReadOnly
  ]
  def createDevEnvironment(request: CreateDevEnvironmentRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly
  ]
  def stopDevEnvironmentSession(request: StopDevEnvironmentSessionRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly
  ]
  def stopDevEnvironment(request: StopDevEnvironmentRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly
  ]
  def getSubscription(
      request: GetSubscriptionRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly]
  def listProjects(
      request: ListProjectsRequest
  ): ZStream[Any, AwsError, zio.aws.codecatalyst.model.ProjectSummary.ReadOnly]
  def listProjectsPaginated(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly]
  def listSpaces(
      request: ListSpacesRequest
  ): ZStream[Any, AwsError, zio.aws.codecatalyst.model.SpaceSummary.ReadOnly]
  def listSpacesPaginated(
      request: ListSpacesRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.CreateProjectResponse.ReadOnly]
  def createSourceRepositoryBranch(
      request: CreateSourceRepositoryBranchRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.ReadOnly
  ]
  def deleteAccessToken(
      request: DeleteAccessTokenRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.DeleteAccessTokenResponse.ReadOnly]
  def verifySession()
      : IO[AwsError, zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly]
  def getSourceRepositoryCloneUrls(
      request: GetSourceRepositoryCloneUrlsRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.ReadOnly
  ]
  def getUserDetails(
      request: GetUserDetailsRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly]
  def getSpace(
      request: GetSpaceRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.GetSpaceResponse.ReadOnly]
  def deleteDevEnvironment(request: DeleteDevEnvironmentRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.ReadOnly
  ]
  def updateSpace(
      request: UpdateSpaceRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly]
  def listSourceRepositoryBranches(
      request: ListSourceRepositoryBranchesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
  ]
  def listSourceRepositoryBranchesPaginated(
      request: ListSourceRepositoryBranchesRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly
  ]
  def startDevEnvironment(
      request: StartDevEnvironmentRequest
  ): IO[AwsError, ReadOnly]
  def listDevEnvironments(request: ListDevEnvironmentsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly
  ]
  def listDevEnvironmentsPaginated(request: ListDevEnvironmentsRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.ReadOnly
  ]
  def deleteSpace(
      request: DeleteSpaceRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly]
  def startDevEnvironmentSession(
      request: StartDevEnvironmentSessionRequest
  ): IO[
    AwsError,
    zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly
  ]
  def deleteProject(
      request: DeleteProjectRequest
  ): IO[AwsError, zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly]
  def createSourceRepository(request: CreateSourceRepositoryRequest): IO[
    AwsError,
    zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly
  ]
}
object CodeCatalyst {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeCatalyst] = customized(
    identity
  )
  def customized(
      customization: CodeCatalystAsyncClientBuilder => CodeCatalystAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeCatalyst] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CodeCatalystAsyncClientBuilder => CodeCatalystAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CodeCatalyst] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CodeCatalystAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeCatalystAsyncClient, CodeCatalystAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      CodeCatalystAsyncClient,
      CodeCatalystAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new CodeCatalystImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeCatalystImpl[R](
      override val api: CodeCatalystAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeCatalyst
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeCatalyst"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeCatalystImpl[R1] = new CodeCatalystImpl(api, newAspect, r)
    def getSourceRepository(request: GetSourceRepositoryRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryRequest,
      GetSourceRepositoryResponse
    ]("getSourceRepository", api.getSourceRepository)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.GetSourceRepositoryResponse.wrap)
      .provideEnvironment(r)
    def getProject(
        request: GetProjectRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.GetProjectRequest,
        GetProjectResponse
      ]("getProject", api.getProject)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.GetProjectResponse.wrap)
        .provideEnvironment(r)
    def createAccessToken(request: CreateAccessTokenRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenRequest,
      CreateAccessTokenResponse
    ]("createAccessToken", api.createAccessToken)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.CreateAccessTokenResponse.wrap)
      .provideEnvironment(r)
    def updateDevEnvironment(request: UpdateDevEnvironmentRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.UpdateDevEnvironmentRequest,
      UpdateDevEnvironmentResponse
    ]("updateDevEnvironment", api.updateDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listDevEnvironmentSessions(
        request: ListDevEnvironmentSessionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest,
      DevEnvironmentSessionSummary,
      ListDevEnvironmentSessionsPublisher
    ](
      "listDevEnvironmentSessions",
      api.listDevEnvironmentSessionsPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDevEnvironmentSessionsPaginated(
        request: ListDevEnvironmentSessionsRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentSessionsRequest,
      ListDevEnvironmentSessionsResponse
    ]("listDevEnvironmentSessions", api.listDevEnvironmentSessions)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.wrap)
      .provideEnvironment(r)
    def listSourceRepositories(request: ListSourceRepositoriesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest,
      ListSourceRepositoriesItem,
      ListSourceRepositoriesPublisher
    ]("listSourceRepositories", api.listSourceRepositoriesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item =>
      zio.aws.codecatalyst.model.ListSourceRepositoriesItem.wrap(item)
    ).provideEnvironment(r)
    def listSourceRepositoriesPaginated(
        request: ListSourceRepositoriesRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest,
      ListSourceRepositoriesResponse
    ]("listSourceRepositories", api.listSourceRepositories)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.wrap)
      .provideEnvironment(r)
    def updateProject(
        request: UpdateProjectRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.UpdateProjectRequest,
        UpdateProjectResponse
      ]("updateProject", api.updateProject)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def listAccessTokens(request: ListAccessTokensRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest,
      AccessTokenSummary,
      ListAccessTokensPublisher
    ]("listAccessTokens", api.listAccessTokensPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecatalyst.model.AccessTokenSummary.wrap(item))
      .provideEnvironment(r)
    def listAccessTokensPaginated(request: ListAccessTokensRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest,
      ListAccessTokensResponse
    ]("listAccessTokens", api.listAccessTokens)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.ListAccessTokensResponse.wrap)
      .provideEnvironment(r)
    def getDevEnvironment(request: GetDevEnvironmentRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.GetDevEnvironmentRequest,
      GetDevEnvironmentResponse
    ]("getDevEnvironment", api.getDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.GetDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listEventLogs(request: ListEventLogsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.EventLogEntry.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest,
      EventLogEntry,
      ListEventLogsPublisher
    ]("listEventLogs", api.listEventLogsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecatalyst.model.EventLogEntry.wrap(item))
      .provideEnvironment(r)
    def listEventLogsPaginated(
        request: ListEventLogsRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.ListEventLogsRequest,
        ListEventLogsResponse
      ]("listEventLogs", api.listEventLogs)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.ListEventLogsResponse.wrap)
        .provideEnvironment(r)
    def deleteSourceRepository(request: DeleteSourceRepositoryRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.DeleteSourceRepositoryRequest,
      DeleteSourceRepositoryResponse
    ]("deleteSourceRepository", api.deleteSourceRepository)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.wrap)
      .provideEnvironment(r)
    def createDevEnvironment(request: CreateDevEnvironmentRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest,
      CreateDevEnvironmentResponse
    ]("createDevEnvironment", api.createDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def stopDevEnvironmentSession(
        request: StopDevEnvironmentSessionRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest,
      StopDevEnvironmentSessionResponse
    ]("stopDevEnvironmentSession", api.stopDevEnvironmentSession)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.wrap)
      .provideEnvironment(r)
    def stopDevEnvironment(request: StopDevEnvironmentRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest,
      StopDevEnvironmentResponse
    ]("stopDevEnvironment", api.stopDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.StopDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def getSubscription(request: GetSubscriptionRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.GetSubscriptionRequest,
      GetSubscriptionResponse
    ]("getSubscription", api.getSubscription)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.GetSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listProjects(request: ListProjectsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.ProjectSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest,
      ProjectSummary,
      ListProjectsPublisher
    ]("listProjects", api.listProjectsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecatalyst.model.ProjectSummary.wrap(item))
      .provideEnvironment(r)
    def listProjectsPaginated(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def listSpaces(request: ListSpacesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.SpaceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest,
      SpaceSummary,
      ListSpacesPublisher
    ]("listSpaces", api.listSpacesPaginator, _.items())(request.buildAwsValue())
      .map(item => zio.aws.codecatalyst.model.SpaceSummary.wrap(item))
      .provideEnvironment(r)
    def listSpacesPaginated(
        request: ListSpacesRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.ListSpacesRequest,
        ListSpacesResponse
      ]("listSpaces", api.listSpaces)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.ListSpacesResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: CreateProjectRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.CreateProjectRequest,
        CreateProjectResponse
      ]("createProject", api.createProject)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def createSourceRepositoryBranch(
        request: CreateSourceRepositoryBranchRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryBranchRequest,
      CreateSourceRepositoryBranchResponse
    ]("createSourceRepositoryBranch", api.createSourceRepositoryBranch)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.wrap)
      .provideEnvironment(r)
    def deleteAccessToken(request: DeleteAccessTokenRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.DeleteAccessTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest,
      DeleteAccessTokenResponse
    ]("deleteAccessToken", api.deleteAccessToken)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.DeleteAccessTokenResponse.wrap)
      .provideEnvironment(r)
    def verifySession(): IO[
      AwsError,
      zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly
    ] = asyncRequestResponse[VerifySessionRequest, VerifySessionResponse](
      "verifySession",
      api.verifySession
    )(VerifySessionRequest.builder().build())
      .map(zio.aws.codecatalyst.model.VerifySessionResponse.wrap)
      .provideEnvironment(r)
    def getSourceRepositoryCloneUrls(
        request: GetSourceRepositoryCloneUrlsRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.GetSourceRepositoryCloneUrlsRequest,
      GetSourceRepositoryCloneUrlsResponse
    ]("getSourceRepositoryCloneUrls", api.getSourceRepositoryCloneUrls)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.wrap)
      .provideEnvironment(r)
    def getUserDetails(request: GetUserDetailsRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.GetUserDetailsRequest,
      GetUserDetailsResponse
    ]("getUserDetails", api.getUserDetails)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.GetUserDetailsResponse.wrap)
      .provideEnvironment(r)
    def getSpace(
        request: GetSpaceRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.GetSpaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.GetSpaceRequest,
        GetSpaceResponse
      ]("getSpace", api.getSpace)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.GetSpaceResponse.wrap)
        .provideEnvironment(r)
    def deleteDevEnvironment(request: DeleteDevEnvironmentRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.DeleteDevEnvironmentRequest,
      DeleteDevEnvironmentResponse
    ]("deleteDevEnvironment", api.deleteDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def updateSpace(
        request: UpdateSpaceRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest,
        UpdateSpaceResponse
      ]("updateSpace", api.updateSpace)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.UpdateSpaceResponse.wrap)
        .provideEnvironment(r)
    def listSourceRepositoryBranches(
        request: ListSourceRepositoryBranchesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest,
      ListSourceRepositoryBranchesItem,
      ListSourceRepositoryBranchesPublisher
    ](
      "listSourceRepositoryBranches",
      api.listSourceRepositoryBranchesPaginator,
      _.items()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.wrap(item)
      )
      .provideEnvironment(r)
    def listSourceRepositoryBranchesPaginated(
        request: ListSourceRepositoryBranchesRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest,
      ListSourceRepositoryBranchesResponse
    ]("listSourceRepositoryBranches", api.listSourceRepositoryBranches)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.wrap)
      .provideEnvironment(r)
    def startDevEnvironment(
        request: StartDevEnvironmentRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentRequest,
      StartDevEnvironmentResponse
    ]("startDevEnvironment", api.startDevEnvironment)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.StartDevEnvironmentResponse.wrap)
      .provideEnvironment(r)
    def listDevEnvironments(request: ListDevEnvironmentsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest,
      DevEnvironmentSummary,
      ListDevEnvironmentsPublisher
    ]("listDevEnvironments", api.listDevEnvironmentsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.codecatalyst.model.DevEnvironmentSummary.wrap(item))
      .provideEnvironment(r)
    def listDevEnvironmentsPaginated(request: ListDevEnvironmentsRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.ListDevEnvironmentsRequest,
      ListDevEnvironmentsResponse
    ]("listDevEnvironments", api.listDevEnvironments)(request.buildAwsValue())
      .map(zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.wrap)
      .provideEnvironment(r)
    def deleteSpace(
        request: DeleteSpaceRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.DeleteSpaceRequest,
        DeleteSpaceResponse
      ]("deleteSpace", api.deleteSpace)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.DeleteSpaceResponse.wrap)
        .provideEnvironment(r)
    def startDevEnvironmentSession(
        request: StartDevEnvironmentSessionRequest
    ): IO[
      AwsError,
      zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.StartDevEnvironmentSessionRequest,
      StartDevEnvironmentSessionResponse
    ]("startDevEnvironmentSession", api.startDevEnvironmentSession)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.wrap)
      .provideEnvironment(r)
    def deleteProject(
        request: DeleteProjectRequest
    ): IO[AwsError, zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest,
        DeleteProjectResponse
      ]("deleteProject", api.deleteProject)(request.buildAwsValue())
        .map(zio.aws.codecatalyst.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def createSourceRepository(request: CreateSourceRepositoryRequest): IO[
      AwsError,
      zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codecatalyst.model.CreateSourceRepositoryRequest,
      CreateSourceRepositoryResponse
    ]("createSourceRepository", api.createSourceRepository)(
      request.buildAwsValue()
    ).map(zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.wrap)
      .provideEnvironment(r)
  }
  def getSourceRepository(request: GetSourceRepositoryRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSourceRepository(request))
  def getProject(request: GetProjectRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getProject(request))
  def createAccessToken(request: CreateAccessTokenRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAccessToken(request))
  def updateDevEnvironment(request: UpdateDevEnvironmentRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDevEnvironment(request))
  def listDevEnvironmentSessions(
      request: ListDevEnvironmentSessionsRequest
  ): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevEnvironmentSessions(request))
  def listDevEnvironmentSessionsPaginated(
      request: ListDevEnvironmentSessionsRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevEnvironmentSessionsPaginated(request))
  def listSourceRepositories(request: ListSourceRepositoriesRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listSourceRepositories(request))
  def listSourceRepositoriesPaginated(
      request: ListSourceRepositoriesRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSourceRepositoriesPaginated(request))
  def updateProject(request: UpdateProjectRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def listAccessTokens(request: ListAccessTokensRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listAccessTokens(request))
  def listAccessTokensPaginated(request: ListAccessTokensRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAccessTokensPaginated(request))
  def getDevEnvironment(request: GetDevEnvironmentRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDevEnvironment(request))
  def listEventLogs(request: ListEventLogsRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.EventLogEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventLogs(request))
  def listEventLogsPaginated(request: ListEventLogsRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventLogsPaginated(request))
  def deleteSourceRepository(request: DeleteSourceRepositoryRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSourceRepository(request))
  def createDevEnvironment(request: CreateDevEnvironmentRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDevEnvironment(request))
  def stopDevEnvironmentSession(request: StopDevEnvironmentSessionRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDevEnvironmentSession(request))
  def stopDevEnvironment(request: StopDevEnvironmentRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDevEnvironment(request))
  def getSubscription(request: GetSubscriptionRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubscription(request))
  def listProjects(request: ListProjectsRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ProjectSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listProjects(request))
  def listProjectsPaginated(request: ListProjectsRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjectsPaginated(request))
  def listSpaces(request: ListSpacesRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.SpaceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listSpaces(request))
  def listSpacesPaginated(request: ListSpacesRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSpacesPaginated(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def createSourceRepositoryBranch(
      request: CreateSourceRepositoryBranchRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSourceRepositoryBranch(request))
  def deleteAccessToken(request: DeleteAccessTokenRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DeleteAccessTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAccessToken(request))
  def verifySession(): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.verifySession())
  def getSourceRepositoryCloneUrls(
      request: GetSourceRepositoryCloneUrlsRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSourceRepositoryCloneUrls(request))
  def getUserDetails(request: GetUserDetailsRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserDetails(request))
  def getSpace(request: GetSpaceRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.GetSpaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSpace(request))
  def deleteDevEnvironment(request: DeleteDevEnvironmentRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDevEnvironment(request))
  def updateSpace(request: UpdateSpaceRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSpace(request))
  def listSourceRepositoryBranches(
      request: ListSourceRepositoryBranchesRequest
  ): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
  ] = ZStream.serviceWithStream(_.listSourceRepositoryBranches(request))
  def listSourceRepositoryBranchesPaginated(
      request: ListSourceRepositoryBranchesRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSourceRepositoryBranchesPaginated(request))
  def startDevEnvironment(
      request: StartDevEnvironmentRequest
  ): ZIO[zio.aws.codecatalyst.CodeCatalyst, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.startDevEnvironment(request))
  def listDevEnvironments(request: ListDevEnvironmentsRequest): ZStream[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDevEnvironments(request))
  def listDevEnvironmentsPaginated(request: ListDevEnvironmentsRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevEnvironmentsPaginated(request))
  def deleteSpace(request: DeleteSpaceRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSpace(request))
  def startDevEnvironmentSession(
      request: StartDevEnvironmentSessionRequest
  ): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDevEnvironmentSession(request))
  def deleteProject(request: DeleteProjectRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def createSourceRepository(request: CreateSourceRepositoryRequest): ZIO[
    zio.aws.codecatalyst.CodeCatalyst,
    AwsError,
    zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSourceRepository(request))
}
