package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DevEnvironmentSessionConfiguration(
    sessionType: zio.aws.codecatalyst.model.DevEnvironmentSessionType,
    executeCommandSessionConfiguration: Optional[
      zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration = {
    import DevEnvironmentSessionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration
      .builder()
      .sessionType(sessionType.unwrap)
      .optionallyWith(
        executeCommandSessionConfiguration.map(value => value.buildAwsValue())
      )(_.executeCommandSessionConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly =
    zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration
      .wrap(buildAwsValue())
}
object DevEnvironmentSessionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration =
      zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration(
        sessionType,
        executeCommandSessionConfiguration.map(value => value.asEditable)
      )
    def sessionType: zio.aws.codecatalyst.model.DevEnvironmentSessionType
    def executeCommandSessionConfiguration: Optional[
      zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly
    ]
    def getSessionType: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.DevEnvironmentSessionType
    ] = ZIO.succeed(sessionType)
    def getExecuteCommandSessionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executeCommandSessionConfiguration",
      executeCommandSessionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration
  ) extends zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly {
    override val sessionType
        : zio.aws.codecatalyst.model.DevEnvironmentSessionType =
      zio.aws.codecatalyst.model.DevEnvironmentSessionType
        .wrap(impl.sessionType())
    override val executeCommandSessionConfiguration: Optional[
      zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.executeCommandSessionConfiguration())
      .map(value =>
        zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionConfiguration
  ): zio.aws.codecatalyst.model.DevEnvironmentSessionConfiguration.ReadOnly =
    new Wrapper(impl)
}
