package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProjectListFilter(
    key: zio.aws.codecatalyst.model.FilterKey,
    values: Iterable[String],
    comparisonOperator: Optional[
      zio.aws.codecatalyst.model.ComparisonOperator
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ProjectListFilter = {
    import ProjectListFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ProjectListFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(comparisonOperator.map(value => value.unwrap))(
        _.comparisonOperator
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly =
    zio.aws.codecatalyst.model.ProjectListFilter.wrap(buildAwsValue())
}
object ProjectListFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ProjectListFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ProjectListFilter =
      zio.aws.codecatalyst.model
        .ProjectListFilter(key, values, comparisonOperator.map(value => value))
    def key: zio.aws.codecatalyst.model.FilterKey
    def values: List[String]
    def comparisonOperator
        : Optional[zio.aws.codecatalyst.model.ComparisonOperator]
    def getKey: ZIO[Any, Nothing, zio.aws.codecatalyst.model.FilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[String]] = ZIO.succeed(values)
    def getComparisonOperator
        : ZIO[Any, AwsError, zio.aws.codecatalyst.model.ComparisonOperator] =
      AwsError.unwrapOptionField("comparisonOperator", comparisonOperator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ProjectListFilter
  ) extends zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly {
    override val key: zio.aws.codecatalyst.model.FilterKey =
      zio.aws.codecatalyst.model.FilterKey.wrap(impl.key())
    override val values: List[String] = impl
      .values()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val comparisonOperator
        : Optional[zio.aws.codecatalyst.model.ComparisonOperator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comparisonOperator())
        .map(value => zio.aws.codecatalyst.model.ComparisonOperator.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ProjectListFilter
  ): zio.aws.codecatalyst.model.ProjectListFilter.ReadOnly = new Wrapper(impl)
}
