package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetProjectResponse(
    spaceName: Optional[NameString] = Optional.Absent,
    name: String,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse = {
    import GetProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse
      .builder()
      .optionallyWith(
        spaceName.map(value => NameString.unwrap(value): java.lang.String)
      )(_.spaceName)
      .name(name: java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly =
    zio.aws.codecatalyst.model.GetProjectResponse.wrap(buildAwsValue())
}
object GetProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.GetProjectResponse =
      zio.aws.codecatalyst.model.GetProjectResponse(
        spaceName.map(value => value),
        name,
        displayName.map(value => value),
        description.map(value => value)
      )
    def spaceName: Optional[NameString]
    def name: String
    def displayName: Optional[String]
    def description: Optional[String]
    def getSpaceName: ZIO[Any, AwsError, NameString] =
      AwsError.unwrapOptionField("spaceName", spaceName)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse
  ) extends zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly {
    override val spaceName: Optional[NameString] = zio.aws.core.internal
      .optionalFromNullable(impl.spaceName())
      .map(value => zio.aws.codecatalyst.model.primitives.NameString(value))
    override val name: String = impl.name(): String
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.GetProjectResponse
  ): zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly = new Wrapper(impl)
}
