package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  DevEnvironmentSessionSummaryIdString,
  SyntheticTimestamp_date_time,
  Uuid,
  NameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DevEnvironmentSessionSummary(
    spaceName: NameString,
    projectName: NameString,
    devEnvironmentId: Uuid,
    startedTime: SyntheticTimestamp_date_time,
    id: DevEnvironmentSessionSummaryIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary = {
    import DevEnvironmentSessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .devEnvironmentId(Uuid.unwrap(devEnvironmentId): java.lang.String)
      .startedTime(SyntheticTimestamp_date_time.unwrap(startedTime): Instant)
      .id(DevEnvironmentSessionSummaryIdString.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly =
    zio.aws.codecatalyst.model.DevEnvironmentSessionSummary
      .wrap(buildAwsValue())
}
object DevEnvironmentSessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DevEnvironmentSessionSummary =
      zio.aws.codecatalyst.model.DevEnvironmentSessionSummary(
        spaceName,
        projectName,
        devEnvironmentId,
        startedTime,
        id
      )
    def spaceName: NameString
    def projectName: NameString
    def devEnvironmentId: Uuid
    def startedTime: SyntheticTimestamp_date_time
    def id: DevEnvironmentSessionSummaryIdString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getDevEnvironmentId: ZIO[Any, Nothing, Uuid] =
      ZIO.succeed(devEnvironmentId)
    def getStartedTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(startedTime)
    def getId: ZIO[Any, Nothing, DevEnvironmentSessionSummaryIdString] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary
  ) extends zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val devEnvironmentId: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.devEnvironmentId())
    override val startedTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.startedTime())
    override val id: DevEnvironmentSessionSummaryIdString =
      zio.aws.codecatalyst.model.primitives
        .DevEnvironmentSessionSummaryIdString(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionSummary
  ): zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly =
    new Wrapper(impl)
}
