package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters.*
sealed trait ComparisonOperator {
  def unwrap
      : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator
  ): zio.aws.codecatalyst.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.GT =>
      val r = GT
      r
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.LT =>
      val r = LT
      r
    case software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.LE =>
      val r = LE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.EQ
  }
  case object GT extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.GT
  }
  case object GE extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.GE
  }
  case object LT extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.LT
  }
  case object LE extends zio.aws.codecatalyst.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator =
      software.amazon.awssdk.services.codecatalyst.model.ComparisonOperator.LE
  }
}
