package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{SpaceDescription, NameString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSpaceRequest(
    name: NameString,
    description: Optional[SpaceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest = {
    import UpdateSpaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          SpaceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.UpdateSpaceRequest.ReadOnly =
    zio.aws.codecatalyst.model.UpdateSpaceRequest.wrap(buildAwsValue())
}
object UpdateSpaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.UpdateSpaceRequest =
      zio.aws.codecatalyst.model
        .UpdateSpaceRequest(name, description.map(value => value))
    def name: NameString
    def description: Optional[SpaceDescription]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, SpaceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest
  ) extends zio.aws.codecatalyst.model.UpdateSpaceRequest.ReadOnly {
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
    override val description: Optional[SpaceDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.codecatalyst.model.primitives.SpaceDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.UpdateSpaceRequest
  ): zio.aws.codecatalyst.model.UpdateSpaceRequest.ReadOnly = new Wrapper(impl)
}
