package zio.aws.codecatalyst.model
import java.lang.Integer
import zio.aws.codecatalyst.model.primitives.PersistentStorageConfigurationSizeInGiBInteger
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PersistentStorageConfiguration(
    sizeInGiB: PersistentStorageConfigurationSizeInGiBInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration = {
    import PersistentStorageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration
      .builder()
      .sizeInGiB(
        PersistentStorageConfigurationSizeInGiBInteger.unwrap(
          sizeInGiB
        ): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly =
    zio.aws.codecatalyst.model.PersistentStorageConfiguration
      .wrap(buildAwsValue())
}
object PersistentStorageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.PersistentStorageConfiguration =
      zio.aws.codecatalyst.model.PersistentStorageConfiguration(sizeInGiB)
    def sizeInGiB: PersistentStorageConfigurationSizeInGiBInteger
    def getSizeInGiB
        : ZIO[Any, Nothing, PersistentStorageConfigurationSizeInGiBInteger] =
      ZIO.succeed(sizeInGiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration
  ) extends zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly {
    override val sizeInGiB: PersistentStorageConfigurationSizeInGiBInteger =
      zio.aws.codecatalyst.model.primitives
        .PersistentStorageConfigurationSizeInGiBInteger(impl.sizeInGiB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.PersistentStorageConfiguration
  ): zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly =
    new Wrapper(impl)
}
