package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  StopDevEnvironmentSessionResponseSessionIdString,
  Uuid,
  NameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopDevEnvironmentSessionResponse(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    sessionId: StopDevEnvironmentSessionResponseSessionIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse = {
    import StopDevEnvironmentSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .sessionId(
        StopDevEnvironmentSessionResponseSessionIdString.unwrap(
          sessionId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly =
    zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse
      .wrap(buildAwsValue())
}
object StopDevEnvironmentSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse =
      zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse(
        spaceName,
        projectName,
        id,
        sessionId
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def sessionId: StopDevEnvironmentSessionResponseSessionIdString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getSessionId
        : ZIO[Any, Nothing, StopDevEnvironmentSessionResponseSessionIdString] =
      ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse
  ) extends zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val sessionId: StopDevEnvironmentSessionResponseSessionIdString =
      zio.aws.codecatalyst.model.primitives
        .StopDevEnvironmentSessionResponseSessionIdString(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionResponse
  ): zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly =
    new Wrapper(impl)
}
