package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  InactivityTimeoutMinutes,
  CreateDevEnvironmentRequestAliasString,
  ClientToken,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDevEnvironmentRequest(
    spaceName: NameString,
    projectName: NameString,
    repositories: Optional[
      Iterable[zio.aws.codecatalyst.model.RepositoryInput]
    ] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    alias: Optional[CreateDevEnvironmentRequestAliasString] = Optional.Absent,
    ides: Optional[Iterable[zio.aws.codecatalyst.model.IdeConfiguration]] =
      Optional.Absent,
    instanceType: zio.aws.codecatalyst.model.InstanceType,
    inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      Optional.Absent,
    persistentStorage: zio.aws.codecatalyst.model.PersistentStorageConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest = {
    import CreateDevEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        repositories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.repositories)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        alias.map(value =>
          CreateDevEnvironmentRequestAliasString.unwrap(value): java.lang.String
        )
      )(_.alias)
      .optionallyWith(
        ides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ides)
      .instanceType(instanceType.unwrap)
      .optionallyWith(
        inactivityTimeoutMinutes.map(value =>
          InactivityTimeoutMinutes.unwrap(value): Integer
        )
      )(_.inactivityTimeoutMinutes)
      .persistentStorage(persistentStorage.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateDevEnvironmentRequest.ReadOnly =
    zio.aws.codecatalyst.model.CreateDevEnvironmentRequest.wrap(buildAwsValue())
}
object CreateDevEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateDevEnvironmentRequest =
      zio.aws.codecatalyst.model.CreateDevEnvironmentRequest(
        spaceName,
        projectName,
        repositories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        alias.map(value => value),
        ides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceType,
        inactivityTimeoutMinutes.map(value => value),
        persistentStorage.asEditable
      )
    def spaceName: NameString
    def projectName: NameString
    def repositories
        : Optional[List[zio.aws.codecatalyst.model.RepositoryInput.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def alias: Optional[CreateDevEnvironmentRequestAliasString]
    def ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]]
    def instanceType: zio.aws.codecatalyst.model.InstanceType
    def inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes]
    def persistentStorage
        : zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getRepositories: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.RepositoryInput.ReadOnly
    ]] = AwsError.unwrapOptionField("repositories", repositories)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getAlias: ZIO[Any, AwsError, CreateDevEnvironmentRequestAliasString] =
      AwsError.unwrapOptionField("alias", alias)
    def getIdes: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("ides", ides)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.codecatalyst.model.InstanceType] =
      ZIO.succeed(instanceType)
    def getInactivityTimeoutMinutes
        : ZIO[Any, AwsError, InactivityTimeoutMinutes] = AwsError
      .unwrapOptionField("inactivityTimeoutMinutes", inactivityTimeoutMinutes)
    def getPersistentStorage: ZIO[
      Any,
      Nothing,
      zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly
    ] = ZIO.succeed(persistentStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest
  ) extends zio.aws.codecatalyst.model.CreateDevEnvironmentRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val repositories
        : Optional[List[zio.aws.codecatalyst.model.RepositoryInput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.RepositoryInput.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.codecatalyst.model.primitives.ClientToken(value))
    override val alias: Optional[CreateDevEnvironmentRequestAliasString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .CreateDevEnvironmentRequestAliasString(value)
        )
    override val ides
        : Optional[List[zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.IdeConfiguration.wrap(item)
          }.toList
        )
    override val instanceType: zio.aws.codecatalyst.model.InstanceType =
      zio.aws.codecatalyst.model.InstanceType.wrap(impl.instanceType())
    override val inactivityTimeoutMinutes: Optional[InactivityTimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inactivityTimeoutMinutes())
        .map(value =>
          zio.aws.codecatalyst.model.primitives.InactivityTimeoutMinutes(value)
        )
    override val persistentStorage
        : zio.aws.codecatalyst.model.PersistentStorageConfiguration.ReadOnly =
      zio.aws.codecatalyst.model.PersistentStorageConfiguration
        .wrap(impl.persistentStorage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateDevEnvironmentRequest
  ): zio.aws.codecatalyst.model.CreateDevEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
