package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters.*
sealed trait OperationType {
  def unwrap: software.amazon.awssdk.services.codecatalyst.model.OperationType
}
object OperationType {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.OperationType
  ): zio.aws.codecatalyst.model.OperationType = value match {
    case software.amazon.awssdk.services.codecatalyst.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.OperationType.READONLY =>
      val r = READONLY
      r
    case software.amazon.awssdk.services.codecatalyst.model.OperationType.MUTATION =>
      val r = MUTATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecatalyst.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.OperationType =
      software.amazon.awssdk.services.codecatalyst.model.OperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object READONLY extends zio.aws.codecatalyst.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.OperationType =
      software.amazon.awssdk.services.codecatalyst.model.OperationType.READONLY
  }
  case object MUTATION extends zio.aws.codecatalyst.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.OperationType =
      software.amazon.awssdk.services.codecatalyst.model.OperationType.MUTATION
  }
}
