package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  IdeConfigurationNameString,
  IdeConfigurationRuntimeString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IdeConfiguration(
    runtime: Optional[IdeConfigurationRuntimeString] = Optional.Absent,
    name: Optional[IdeConfigurationNameString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration = {
    import IdeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration
      .builder()
      .optionallyWith(
        runtime.map(value =>
          IdeConfigurationRuntimeString.unwrap(value): java.lang.String
        )
      )(_.runtime)
      .optionallyWith(
        name.map(value =>
          IdeConfigurationNameString.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly =
    zio.aws.codecatalyst.model.IdeConfiguration.wrap(buildAwsValue())
}
object IdeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.IdeConfiguration =
      zio.aws.codecatalyst.model
        .IdeConfiguration(runtime.map(value => value), name.map(value => value))
    def runtime: Optional[IdeConfigurationRuntimeString]
    def name: Optional[IdeConfigurationNameString]
    def getRuntime: ZIO[Any, AwsError, IdeConfigurationRuntimeString] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getName: ZIO[Any, AwsError, IdeConfigurationNameString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration
  ) extends zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly {
    override val runtime: Optional[IdeConfigurationRuntimeString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .IdeConfigurationRuntimeString(value)
        )
    override val name: Optional[IdeConfigurationNameString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .IdeConfigurationNameString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.IdeConfiguration
  ): zio.aws.codecatalyst.model.IdeConfiguration.ReadOnly = new Wrapper(impl)
}
