package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  SyntheticTimestamp_date_time,
  AccessTokenName,
  AccessTokenId
}
import scala.jdk.CollectionConverters.*
final case class AccessTokenSummary(
    id: AccessTokenId,
    name: AccessTokenName,
    expiresTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary = {
    import AccessTokenSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary
      .builder()
      .id(AccessTokenId.unwrap(id): java.lang.String)
      .name(AccessTokenName.unwrap(name): java.lang.String)
      .optionallyWith(
        expiresTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.expiresTime)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly =
    zio.aws.codecatalyst.model.AccessTokenSummary.wrap(buildAwsValue())
}
object AccessTokenSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.AccessTokenSummary =
      zio.aws.codecatalyst.model
        .AccessTokenSummary(id, name, expiresTime.map(value => value))
    def id: AccessTokenId
    def name: AccessTokenName
    def expiresTime: Optional[SyntheticTimestamp_date_time]
    def getId: ZIO[Any, Nothing, AccessTokenId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, AccessTokenName] = ZIO.succeed(name)
    def getExpiresTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("expiresTime", expiresTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary
  ) extends zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly {
    override val id: AccessTokenId =
      zio.aws.codecatalyst.model.primitives.AccessTokenId(impl.id())
    override val name: AccessTokenName =
      zio.aws.codecatalyst.model.primitives.AccessTokenName(impl.name())
    override val expiresTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresTime())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.AccessTokenSummary
  ): zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly = new Wrapper(impl)
}
