package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccessTokensResponse(
    items: Iterable[zio.aws.codecatalyst.model.AccessTokenSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse = {
    import ListAccessTokensResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListAccessTokensResponse.wrap(buildAwsValue())
}
object ListAccessTokensResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListAccessTokensResponse =
      zio.aws.codecatalyst.model.ListAccessTokensResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse
  ) extends zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly {
    override val items
        : List[zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.AccessTokenSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensResponse
  ): zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly = new Wrapper(
    impl
  )
}
