package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListAccessTokensRequestNextTokenString,
  ListAccessTokensRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccessTokensRequest(
    maxResults: Optional[ListAccessTokensRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[ListAccessTokensRequestNextTokenString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest = {
    import ListAccessTokensRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListAccessTokensRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          ListAccessTokensRequestNextTokenString.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListAccessTokensRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListAccessTokensRequest.wrap(buildAwsValue())
}
object ListAccessTokensRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListAccessTokensRequest =
      zio.aws.codecatalyst.model.ListAccessTokensRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[ListAccessTokensRequestMaxResultsInteger]
    def nextToken: Optional[ListAccessTokensRequestNextTokenString]
    def getMaxResults
        : ZIO[Any, AwsError, ListAccessTokensRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken
        : ZIO[Any, AwsError, ListAccessTokensRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest
  ) extends zio.aws.codecatalyst.model.ListAccessTokensRequest.ReadOnly {
    override val maxResults
        : Optional[ListAccessTokensRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListAccessTokensRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[ListAccessTokensRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListAccessTokensRequestNextTokenString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListAccessTokensRequest
  ): zio.aws.codecatalyst.model.ListAccessTokensRequest.ReadOnly = new Wrapper(
    impl
  )
}
