package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters.*
sealed trait DevEnvironmentSessionType {
  def unwrap: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType
}
object DevEnvironmentSessionType {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType
  ): zio.aws.codecatalyst.model.DevEnvironmentSessionType = value match {
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.SSM =>
      val r = SSM
      r
    case software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.SSH =>
      val r = SSH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codecatalyst.model.DevEnvironmentSessionType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSM extends zio.aws.codecatalyst.model.DevEnvironmentSessionType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.SSM
  }
  case object SSH extends zio.aws.codecatalyst.model.DevEnvironmentSessionType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType =
      software.amazon.awssdk.services.codecatalyst.model.DevEnvironmentSessionType.SSH
  }
}
