package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  AccessTokenId,
  SyntheticTimestamp_date_time,
  AccessTokenName,
  AccessTokenSecret
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateAccessTokenResponse(
    secret: AccessTokenSecret,
    name: AccessTokenName,
    expiresTime: SyntheticTimestamp_date_time,
    accessTokenId: AccessTokenId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse = {
    import CreateAccessTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
      .builder()
      .secret(AccessTokenSecret.unwrap(secret): java.lang.String)
      .name(AccessTokenName.unwrap(name): java.lang.String)
      .expiresTime(SyntheticTimestamp_date_time.unwrap(expiresTime): Instant)
      .accessTokenId(AccessTokenId.unwrap(accessTokenId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly =
    zio.aws.codecatalyst.model.CreateAccessTokenResponse.wrap(buildAwsValue())
}
object CreateAccessTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateAccessTokenResponse =
      zio.aws.codecatalyst.model.CreateAccessTokenResponse(
        secret,
        name,
        expiresTime,
        accessTokenId
      )
    def secret: AccessTokenSecret
    def name: AccessTokenName
    def expiresTime: SyntheticTimestamp_date_time
    def accessTokenId: AccessTokenId
    def getSecret: ZIO[Any, Nothing, AccessTokenSecret] = ZIO.succeed(secret)
    def getName: ZIO[Any, Nothing, AccessTokenName] = ZIO.succeed(name)
    def getExpiresTime: ZIO[Any, Nothing, SyntheticTimestamp_date_time] =
      ZIO.succeed(expiresTime)
    def getAccessTokenId: ZIO[Any, Nothing, AccessTokenId] =
      ZIO.succeed(accessTokenId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ) extends zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly {
    override val secret: AccessTokenSecret =
      zio.aws.codecatalyst.model.primitives.AccessTokenSecret(impl.secret())
    override val name: AccessTokenName =
      zio.aws.codecatalyst.model.primitives.AccessTokenName(impl.name())
    override val expiresTime: SyntheticTimestamp_date_time =
      zio.aws.codecatalyst.model.primitives
        .SyntheticTimestamp_date_time(impl.expiresTime())
    override val accessTokenId: AccessTokenId =
      zio.aws.codecatalyst.model.primitives.AccessTokenId(impl.accessTokenId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ): zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly =
    new Wrapper(impl)
}
