package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.AccessTokenId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAccessTokenRequest(id: AccessTokenId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest = {
    import DeleteAccessTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest
      .builder()
      .id(AccessTokenId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DeleteAccessTokenRequest.ReadOnly =
    zio.aws.codecatalyst.model.DeleteAccessTokenRequest.wrap(buildAwsValue())
}
object DeleteAccessTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DeleteAccessTokenRequest =
      zio.aws.codecatalyst.model.DeleteAccessTokenRequest(id)
    def id: AccessTokenId
    def getId: ZIO[Any, Nothing, AccessTokenId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest
  ) extends zio.aws.codecatalyst.model.DeleteAccessTokenRequest.ReadOnly {
    override val id: AccessTokenId =
      zio.aws.codecatalyst.model.primitives.AccessTokenId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteAccessTokenRequest
  ): zio.aws.codecatalyst.model.DeleteAccessTokenRequest.ReadOnly = new Wrapper(
    impl
  )
}
