package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  StopDevEnvironmentSessionRequestSessionIdString,
  Uuid,
  NameString
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopDevEnvironmentSessionRequest(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid,
    sessionId: StopDevEnvironmentSessionRequestSessionIdString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest = {
    import StopDevEnvironmentSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .sessionId(
        StopDevEnvironmentSessionRequestSessionIdString.unwrap(
          sessionId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest.ReadOnly =
    zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest
      .wrap(buildAwsValue())
}
object StopDevEnvironmentSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest =
      zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest(
        spaceName,
        projectName,
        id,
        sessionId
      )
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def sessionId: StopDevEnvironmentSessionRequestSessionIdString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
    def getSessionId
        : ZIO[Any, Nothing, StopDevEnvironmentSessionRequestSessionIdString] =
      ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest
  ) extends zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
    override val sessionId: StopDevEnvironmentSessionRequestSessionIdString =
      zio.aws.codecatalyst.model.primitives
        .StopDevEnvironmentSessionRequestSessionIdString(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentSessionRequest
  ): zio.aws.codecatalyst.model.StopDevEnvironmentSessionRequest.ReadOnly =
    new Wrapper(impl)
}
