package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEventLogsResponse(
    nextToken: Optional[String] = Optional.Absent,
    items: Iterable[zio.aws.codecatalyst.model.EventLogEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse = {
    import ListEventLogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListEventLogsResponse.wrap(buildAwsValue())
}
object ListEventLogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListEventLogsResponse =
      zio.aws.codecatalyst.model.ListEventLogsResponse(
        nextToken.map(value => value),
        items.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def items: List[zio.aws.codecatalyst.model.EventLogEntry.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.codecatalyst.model.EventLogEntry.ReadOnly
    ]] = ZIO.succeed(items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse
  ) extends zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val items
        : List[zio.aws.codecatalyst.model.EventLogEntry.ReadOnly] = impl
      .items()
      .asScala
      .map { item =>
        zio.aws.codecatalyst.model.EventLogEntry.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListEventLogsResponse
  ): zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly = new Wrapper(
    impl
  )
}
