package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  ExecuteCommandSessionConfigurationArgumentsMemberString,
  ExecuteCommandSessionConfigurationCommandString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExecuteCommandSessionConfiguration(
    command: ExecuteCommandSessionConfigurationCommandString,
    arguments: Optional[
      Iterable[ExecuteCommandSessionConfigurationArgumentsMemberString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration = {
    import ExecuteCommandSessionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration
      .builder()
      .command(
        ExecuteCommandSessionConfigurationCommandString.unwrap(
          command
        ): java.lang.String
      )
      .optionallyWith(
        arguments.map(value =>
          value.map { item =>
            ExecuteCommandSessionConfigurationArgumentsMemberString.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.arguments)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly =
    zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration
      .wrap(buildAwsValue())
}
object ExecuteCommandSessionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration =
      zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration(
        command,
        arguments.map(value => value)
      )
    def command: ExecuteCommandSessionConfigurationCommandString
    def arguments: Optional[
      List[ExecuteCommandSessionConfigurationArgumentsMemberString]
    ]
    def getCommand
        : ZIO[Any, Nothing, ExecuteCommandSessionConfigurationCommandString] =
      ZIO.succeed(command)
    def getArguments: ZIO[Any, AwsError, List[
      ExecuteCommandSessionConfigurationArgumentsMemberString
    ]] = AwsError.unwrapOptionField("arguments", arguments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration
  ) extends zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly {
    override val command: ExecuteCommandSessionConfigurationCommandString =
      zio.aws.codecatalyst.model.primitives
        .ExecuteCommandSessionConfigurationCommandString(impl.command())
    override val arguments: Optional[
      List[ExecuteCommandSessionConfigurationArgumentsMemberString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.arguments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codecatalyst.model.primitives
            .ExecuteCommandSessionConfigurationArgumentsMemberString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ExecuteCommandSessionConfiguration
  ): zio.aws.codecatalyst.model.ExecuteCommandSessionConfiguration.ReadOnly =
    new Wrapper(impl)
}
