package zio.aws.codecatalyst.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSpacesResponse(
    nextToken: Optional[String] = Optional.Absent,
    items: Optional[Iterable[zio.aws.codecatalyst.model.SpaceSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse = {
    import ListSpacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly =
    zio.aws.codecatalyst.model.ListSpacesResponse.wrap(buildAwsValue())
}
object ListSpacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListSpacesResponse =
      zio.aws.codecatalyst.model.ListSpacesResponse(
        nextToken.map(value => value),
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def items: Optional[List[zio.aws.codecatalyst.model.SpaceSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.codecatalyst.model.SpaceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse
  ) extends zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val items
        : Optional[List[zio.aws.codecatalyst.model.SpaceSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codecatalyst.model.SpaceSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSpacesResponse
  ): zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly = new Wrapper(impl)
}
