package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{
  SourceRepositoryBranchString,
  SourceRepositoryNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RepositoryInput(
    repositoryName: SourceRepositoryNameString,
    branchName: Optional[SourceRepositoryBranchString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.RepositoryInput = {
    import RepositoryInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.RepositoryInput
      .builder()
      .repositoryName(
        SourceRepositoryNameString.unwrap(repositoryName): java.lang.String
      )
      .optionallyWith(
        branchName.map(value =>
          SourceRepositoryBranchString.unwrap(value): java.lang.String
        )
      )(_.branchName)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.RepositoryInput.ReadOnly =
    zio.aws.codecatalyst.model.RepositoryInput.wrap(buildAwsValue())
}
object RepositoryInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.RepositoryInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.RepositoryInput =
      zio.aws.codecatalyst.model
        .RepositoryInput(repositoryName, branchName.map(value => value))
    def repositoryName: SourceRepositoryNameString
    def branchName: Optional[SourceRepositoryBranchString]
    def getRepositoryName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(repositoryName)
    def getBranchName: ZIO[Any, AwsError, SourceRepositoryBranchString] =
      AwsError.unwrapOptionField("branchName", branchName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.RepositoryInput
  ) extends zio.aws.codecatalyst.model.RepositoryInput.ReadOnly {
    override val repositoryName: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.repositoryName())
    override val branchName: Optional[SourceRepositoryBranchString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branchName())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SourceRepositoryBranchString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.RepositoryInput
  ): zio.aws.codecatalyst.model.RepositoryInput.ReadOnly = new Wrapper(impl)
}
