package zio.aws.codecatalyst.model
import scala.jdk.CollectionConverters.*
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.codecatalyst.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.codecatalyst.model.UserType
  ): zio.aws.codecatalyst.model.UserType = value match {
    case software.amazon.awssdk.services.codecatalyst.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codecatalyst.model.UserType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.codecatalyst.model.UserType.AWS_ACCOUNT =>
      val r = AWS_ACCOUNT
      r
    case software.amazon.awssdk.services.codecatalyst.model.UserType.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.codecatalyst.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.UserType =
      software.amazon.awssdk.services.codecatalyst.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.codecatalyst.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.UserType =
      software.amazon.awssdk.services.codecatalyst.model.UserType.USER
  }
  case object AWS_ACCOUNT extends zio.aws.codecatalyst.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.UserType =
      software.amazon.awssdk.services.codecatalyst.model.UserType.AWS_ACCOUNT
  }
  case object UNKNOWN extends zio.aws.codecatalyst.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.codecatalyst.model.UserType =
      software.amazon.awssdk.services.codecatalyst.model.UserType.UNKNOWN
  }
}
