package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{Uuid, NameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StopDevEnvironmentRequest(
    spaceName: NameString,
    projectName: NameString,
    id: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest = {
    import StopDevEnvironmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .id(Uuid.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.StopDevEnvironmentRequest.ReadOnly =
    zio.aws.codecatalyst.model.StopDevEnvironmentRequest.wrap(buildAwsValue())
}
object StopDevEnvironmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.StopDevEnvironmentRequest =
      zio.aws.codecatalyst.model
        .StopDevEnvironmentRequest(spaceName, projectName, id)
    def spaceName: NameString
    def projectName: NameString
    def id: Uuid
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest
  ) extends zio.aws.codecatalyst.model.StopDevEnvironmentRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val id: Uuid =
      zio.aws.codecatalyst.model.primitives.Uuid(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.StopDevEnvironmentRequest
  ): zio.aws.codecatalyst.model.StopDevEnvironmentRequest.ReadOnly =
    new Wrapper(impl)
}
