package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListSourceRepositoryBranchesRequestMaxResultsInteger,
  ListSourceRepositoryBranchesRequestNextTokenString,
  SourceRepositoryNameString,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSourceRepositoryBranchesRequest(
    spaceName: NameString,
    projectName: NameString,
    sourceRepositoryName: SourceRepositoryNameString,
    nextToken: Optional[ListSourceRepositoryBranchesRequestNextTokenString] =
      Optional.Absent,
    maxResults: Optional[ListSourceRepositoryBranchesRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest = {
    import ListSourceRepositoryBranchesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .sourceRepositoryName(
        SourceRepositoryNameString.unwrap(
          sourceRepositoryName
        ): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value =>
          ListSourceRepositoryBranchesRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListSourceRepositoryBranchesRequestMaxResultsInteger.unwrap(
            value
          ): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest
      .wrap(buildAwsValue())
}
object ListSourceRepositoryBranchesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest =
      zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest(
        spaceName,
        projectName,
        sourceRepositoryName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def sourceRepositoryName: SourceRepositoryNameString
    def nextToken: Optional[ListSourceRepositoryBranchesRequestNextTokenString]
    def maxResults
        : Optional[ListSourceRepositoryBranchesRequestMaxResultsInteger]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getSourceRepositoryName: ZIO[Any, Nothing, SourceRepositoryNameString] =
      ZIO.succeed(sourceRepositoryName)
    def getNextToken: ZIO[
      Any,
      AwsError,
      ListSourceRepositoryBranchesRequestNextTokenString
    ] = AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[
      Any,
      AwsError,
      ListSourceRepositoryBranchesRequestMaxResultsInteger
    ] = AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val sourceRepositoryName: SourceRepositoryNameString =
      zio.aws.codecatalyst.model.primitives
        .SourceRepositoryNameString(impl.sourceRepositoryName())
    override val nextToken
        : Optional[ListSourceRepositoryBranchesRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListSourceRepositoryBranchesRequestNextTokenString(value)
        )
    override val maxResults
        : Optional[ListSourceRepositoryBranchesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListSourceRepositoryBranchesRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoryBranchesRequest
  ): zio.aws.codecatalyst.model.ListSourceRepositoryBranchesRequest.ReadOnly =
    new Wrapper(impl)
}
