package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.{RegionString, NameString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SpaceSummary(
    name: NameString,
    regionName: RegionString,
    displayName: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.SpaceSummary = {
    import SpaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.SpaceSummary
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .regionName(RegionString.unwrap(regionName): java.lang.String)
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.SpaceSummary.ReadOnly =
    zio.aws.codecatalyst.model.SpaceSummary.wrap(buildAwsValue())
}
object SpaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.SpaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.SpaceSummary =
      zio.aws.codecatalyst.model.SpaceSummary(
        name,
        regionName,
        displayName.map(value => value),
        description.map(value => value)
      )
    def name: NameString
    def regionName: RegionString
    def displayName: Optional[String]
    def description: Optional[String]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getRegionName: ZIO[Any, Nothing, RegionString] = ZIO.succeed(regionName)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.SpaceSummary
  ) extends zio.aws.codecatalyst.model.SpaceSummary.ReadOnly {
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
    override val regionName: RegionString =
      zio.aws.codecatalyst.model.primitives.RegionString(impl.regionName())
    override val displayName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.SpaceSummary
  ): zio.aws.codecatalyst.model.SpaceSummary.ReadOnly = new Wrapper(impl)
}
