package zio.aws.codecatalyst.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  ListSourceRepositoriesRequestMaxResultsInteger,
  ListSourceRepositoriesRequestNextTokenString,
  NameString
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListSourceRepositoriesRequest(
    spaceName: NameString,
    projectName: NameString,
    nextToken: Optional[ListSourceRepositoriesRequestNextTokenString] =
      Optional.Absent,
    maxResults: Optional[ListSourceRepositoriesRequestMaxResultsInteger] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest = {
    import ListSourceRepositoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .projectName(NameString.unwrap(projectName): java.lang.String)
      .optionallyWith(
        nextToken.map(value =>
          ListSourceRepositoriesRequestNextTokenString.unwrap(
            value
          ): java.lang.String
        )
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          ListSourceRepositoriesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.ListSourceRepositoriesRequest.ReadOnly =
    zio.aws.codecatalyst.model.ListSourceRepositoriesRequest
      .wrap(buildAwsValue())
}
object ListSourceRepositoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.ListSourceRepositoriesRequest =
      zio.aws.codecatalyst.model.ListSourceRepositoriesRequest(
        spaceName,
        projectName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def spaceName: NameString
    def projectName: NameString
    def nextToken: Optional[ListSourceRepositoriesRequestNextTokenString]
    def maxResults: Optional[ListSourceRepositoriesRequestMaxResultsInteger]
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getProjectName: ZIO[Any, Nothing, NameString] = ZIO.succeed(projectName)
    def getNextToken
        : ZIO[Any, AwsError, ListSourceRepositoriesRequestNextTokenString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, ListSourceRepositoriesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest
  ) extends zio.aws.codecatalyst.model.ListSourceRepositoriesRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val projectName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.projectName())
    override val nextToken
        : Optional[ListSourceRepositoriesRequestNextTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListSourceRepositoriesRequestNextTokenString(value)
        )
    override val maxResults
        : Optional[ListSourceRepositoriesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .ListSourceRepositoriesRequestMaxResultsInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.ListSourceRepositoriesRequest
  ): zio.aws.codecatalyst.model.ListSourceRepositoriesRequest.ReadOnly =
    new Wrapper(impl)
}
