package zio.aws.codecatalyst.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codecatalyst.model.primitives.{
  SyntheticTimestamp_date_time,
  AccessTokenName,
  AccessTokenSecret
}
import scala.jdk.CollectionConverters.*
final case class CreateAccessTokenResponse(
    secret: AccessTokenSecret,
    name: Optional[AccessTokenName] = Optional.Absent,
    expiresTime: Optional[SyntheticTimestamp_date_time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse = {
    import CreateAccessTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
      .builder()
      .secret(AccessTokenSecret.unwrap(secret): java.lang.String)
      .optionallyWith(
        name.map(value => AccessTokenName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        expiresTime.map(value =>
          SyntheticTimestamp_date_time.unwrap(value): Instant
        )
      )(_.expiresTime)
      .build()
  }
  def asReadOnly
      : zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly =
    zio.aws.codecatalyst.model.CreateAccessTokenResponse.wrap(buildAwsValue())
}
object CreateAccessTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.CreateAccessTokenResponse =
      zio.aws.codecatalyst.model.CreateAccessTokenResponse(
        secret,
        name.map(value => value),
        expiresTime.map(value => value)
      )
    def secret: AccessTokenSecret
    def name: Optional[AccessTokenName]
    def expiresTime: Optional[SyntheticTimestamp_date_time]
    def getSecret: ZIO[Any, Nothing, AccessTokenSecret] = ZIO.succeed(secret)
    def getName: ZIO[Any, AwsError, AccessTokenName] =
      AwsError.unwrapOptionField("name", name)
    def getExpiresTime: ZIO[Any, AwsError, SyntheticTimestamp_date_time] =
      AwsError.unwrapOptionField("expiresTime", expiresTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ) extends zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly {
    override val secret: AccessTokenSecret =
      zio.aws.codecatalyst.model.primitives.AccessTokenSecret(impl.secret())
    override val name: Optional[AccessTokenName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.codecatalyst.model.primitives.AccessTokenName(value)
      )
    override val expiresTime: Optional[SyntheticTimestamp_date_time] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresTime())
        .map(value =>
          zio.aws.codecatalyst.model.primitives
            .SyntheticTimestamp_date_time(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.CreateAccessTokenResponse
  ): zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly =
    new Wrapper(impl)
}
