package zio.aws.codecatalyst.model
import zio.aws.codecatalyst.model.primitives.NameString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProjectRequest(spaceName: NameString, name: NameString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest
      .builder()
      .spaceName(NameString.unwrap(spaceName): java.lang.String)
      .name(NameString.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codecatalyst.model.DeleteProjectRequest.ReadOnly =
    zio.aws.codecatalyst.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codecatalyst.model.DeleteProjectRequest =
      zio.aws.codecatalyst.model.DeleteProjectRequest(spaceName, name)
    def spaceName: NameString
    def name: NameString
    def getSpaceName: ZIO[Any, Nothing, NameString] = ZIO.succeed(spaceName)
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest
  ) extends zio.aws.codecatalyst.model.DeleteProjectRequest.ReadOnly {
    override val spaceName: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.spaceName())
    override val name: NameString =
      zio.aws.codecatalyst.model.primitives.NameString(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codecatalyst.model.DeleteProjectRequest
  ): zio.aws.codecatalyst.model.DeleteProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
