package zio.aws.codecatalyst
import zio.aws.codecatalyst.model.StartDevEnvironmentResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.codecatalyst.model.{
  StartDevEnvironmentRequest,
  UpdateDevEnvironmentRequest,
  UpdateSpaceRequest,
  GetSourceRepositoryCloneUrlsRequest,
  GetProjectRequest,
  CreateAccessTokenRequest,
  StartDevEnvironmentSessionRequest,
  ListEventLogsRequest,
  CreateProjectRequest,
  ListDevEnvironmentSessionsRequest,
  GetDevEnvironmentRequest,
  GetSourceRepositoryRequest,
  GetUserDetailsRequest,
  CreateSourceRepositoryBranchRequest,
  ListSourceRepositoriesRequest,
  DeleteSourceRepositoryRequest,
  GetSpaceRequest,
  UpdateProjectRequest,
  DeleteDevEnvironmentRequest,
  StopDevEnvironmentSessionRequest,
  DeleteProjectRequest,
  StopDevEnvironmentRequest,
  ListSpacesRequest,
  ListAccessTokensRequest,
  CreateSourceRepositoryRequest,
  ListProjectsRequest,
  DeleteAccessTokenRequest,
  GetSubscriptionRequest,
  ListSourceRepositoryBranchesRequest,
  ListDevEnvironmentsRequest,
  DeleteSpaceRequest,
  CreateDevEnvironmentRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.codecatalyst.CodeCatalystAsyncClient
object CodeCatalystMock extends Mock[CodeCatalyst] {
  object GetSourceRepository
      extends Effect[
        GetSourceRepositoryRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly
      ]
  object GetProject
      extends Effect[
        GetProjectRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly
      ]
  object CreateAccessToken
      extends Effect[
        CreateAccessTokenRequest,
        AwsError,
        zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly
      ]
  object UpdateDevEnvironment
      extends Effect[
        UpdateDevEnvironmentRequest,
        AwsError,
        zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly
      ]
  object ListDevEnvironmentSessions
      extends Stream[
        ListDevEnvironmentSessionsRequest,
        AwsError,
        zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
      ]
  object ListDevEnvironmentSessionsPaginated
      extends Effect[
        ListDevEnvironmentSessionsRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly
      ]
  object ListSourceRepositories
      extends Stream[
        ListSourceRepositoriesRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
      ]
  object ListSourceRepositoriesPaginated
      extends Effect[
        ListSourceRepositoriesRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly
      ]
  object UpdateProject
      extends Effect[
        UpdateProjectRequest,
        AwsError,
        zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly
      ]
  object ListAccessTokens
      extends Stream[
        ListAccessTokensRequest,
        AwsError,
        zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
      ]
  object ListAccessTokensPaginated
      extends Effect[
        ListAccessTokensRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly
      ]
  object GetDevEnvironment
      extends Effect[
        GetDevEnvironmentRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly
      ]
  object ListEventLogs
      extends Stream[
        ListEventLogsRequest,
        AwsError,
        zio.aws.codecatalyst.model.EventLogEntry.ReadOnly
      ]
  object ListEventLogsPaginated
      extends Effect[
        ListEventLogsRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly
      ]
  object DeleteSourceRepository
      extends Effect[
        DeleteSourceRepositoryRequest,
        AwsError,
        zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.ReadOnly
      ]
  object CreateDevEnvironment
      extends Effect[
        CreateDevEnvironmentRequest,
        AwsError,
        zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly
      ]
  object StopDevEnvironmentSession
      extends Effect[
        StopDevEnvironmentSessionRequest,
        AwsError,
        zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly
      ]
  object StopDevEnvironment
      extends Effect[
        StopDevEnvironmentRequest,
        AwsError,
        zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly
      ]
  object GetSubscription
      extends Effect[
        GetSubscriptionRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly
      ]
  object ListProjects
      extends Stream[
        ListProjectsRequest,
        AwsError,
        zio.aws.codecatalyst.model.ProjectSummary.ReadOnly
      ]
  object ListProjectsPaginated
      extends Effect[
        ListProjectsRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly
      ]
  object ListSpaces
      extends Stream[
        ListSpacesRequest,
        AwsError,
        zio.aws.codecatalyst.model.SpaceSummary.ReadOnly
      ]
  object ListSpacesPaginated
      extends Effect[
        ListSpacesRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly
      ]
  object CreateProject
      extends Effect[
        CreateProjectRequest,
        AwsError,
        zio.aws.codecatalyst.model.CreateProjectResponse.ReadOnly
      ]
  object CreateSourceRepositoryBranch
      extends Effect[
        CreateSourceRepositoryBranchRequest,
        AwsError,
        zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.ReadOnly
      ]
  object DeleteAccessToken
      extends Effect[
        DeleteAccessTokenRequest,
        AwsError,
        zio.aws.codecatalyst.model.DeleteAccessTokenResponse.ReadOnly
      ]
  object VerifySession
      extends Effect[
        Unit,
        AwsError,
        zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly
      ]
  object GetSourceRepositoryCloneUrls
      extends Effect[
        GetSourceRepositoryCloneUrlsRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.ReadOnly
      ]
  object GetUserDetails
      extends Effect[
        GetUserDetailsRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly
      ]
  object GetSpace
      extends Effect[
        GetSpaceRequest,
        AwsError,
        zio.aws.codecatalyst.model.GetSpaceResponse.ReadOnly
      ]
  object DeleteDevEnvironment
      extends Effect[
        DeleteDevEnvironmentRequest,
        AwsError,
        zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.ReadOnly
      ]
  object UpdateSpace
      extends Effect[
        UpdateSpaceRequest,
        AwsError,
        zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly
      ]
  object ListSourceRepositoryBranches
      extends Stream[
        ListSourceRepositoryBranchesRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
      ]
  object ListSourceRepositoryBranchesPaginated
      extends Effect[
        ListSourceRepositoryBranchesRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly
      ]
  object StartDevEnvironment
      extends Effect[StartDevEnvironmentRequest, AwsError, ReadOnly]
  object ListDevEnvironments
      extends Stream[
        ListDevEnvironmentsRequest,
        AwsError,
        zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly
      ]
  object ListDevEnvironmentsPaginated
      extends Effect[
        ListDevEnvironmentsRequest,
        AwsError,
        zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.ReadOnly
      ]
  object DeleteSpace
      extends Effect[
        DeleteSpaceRequest,
        AwsError,
        zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly
      ]
  object StartDevEnvironmentSession
      extends Effect[
        StartDevEnvironmentSessionRequest,
        AwsError,
        zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly
      ]
  object DeleteProject
      extends Effect[
        DeleteProjectRequest,
        AwsError,
        zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly
      ]
  object CreateSourceRepository
      extends Effect[
        CreateSourceRepositoryRequest,
        AwsError,
        zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeCatalyst] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeCatalyst] { rts =>
        zio.ZIO.succeed {
          new CodeCatalyst {
            val api: CodeCatalystAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeCatalyst = this
            def getSourceRepository(request: GetSourceRepositoryRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetSourceRepositoryResponse.ReadOnly
            ] = proxy(GetSourceRepository, request)
            def getProject(request: GetProjectRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetProjectResponse.ReadOnly
            ] = proxy(GetProject, request)
            def createAccessToken(request: CreateAccessTokenRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.CreateAccessTokenResponse.ReadOnly
            ] = proxy(CreateAccessToken, request)
            def updateDevEnvironment(request: UpdateDevEnvironmentRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.UpdateDevEnvironmentResponse.ReadOnly
            ] = proxy(UpdateDevEnvironment, request)
            def listDevEnvironmentSessions(
                request: ListDevEnvironmentSessionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.DevEnvironmentSessionSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDevEnvironmentSessions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDevEnvironmentSessionsPaginated(
                request: ListDevEnvironmentSessionsRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListDevEnvironmentSessionsResponse.ReadOnly
            ] = proxy(ListDevEnvironmentSessionsPaginated, request)
            def listSourceRepositories(
                request: ListSourceRepositoriesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.ListSourceRepositoriesItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSourceRepositories, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSourceRepositoriesPaginated(
                request: ListSourceRepositoriesRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListSourceRepositoriesResponse.ReadOnly
            ] = proxy(ListSourceRepositoriesPaginated, request)
            def updateProject(request: UpdateProjectRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.UpdateProjectResponse.ReadOnly
            ] = proxy(UpdateProject, request)
            def listAccessTokens(request: ListAccessTokensRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.AccessTokenSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccessTokens, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccessTokensPaginated(request: ListAccessTokensRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListAccessTokensResponse.ReadOnly
            ] = proxy(ListAccessTokensPaginated, request)
            def getDevEnvironment(request: GetDevEnvironmentRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetDevEnvironmentResponse.ReadOnly
            ] = proxy(GetDevEnvironment, request)
            def listEventLogs(request: ListEventLogsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.EventLogEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventLogs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventLogsPaginated(request: ListEventLogsRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListEventLogsResponse.ReadOnly
            ] = proxy(ListEventLogsPaginated, request)
            def deleteSourceRepository(
                request: DeleteSourceRepositoryRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.DeleteSourceRepositoryResponse.ReadOnly
            ] = proxy(DeleteSourceRepository, request)
            def createDevEnvironment(request: CreateDevEnvironmentRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.CreateDevEnvironmentResponse.ReadOnly
            ] = proxy(CreateDevEnvironment, request)
            def stopDevEnvironmentSession(
                request: StopDevEnvironmentSessionRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.StopDevEnvironmentSessionResponse.ReadOnly
            ] = proxy(StopDevEnvironmentSession, request)
            def stopDevEnvironment(request: StopDevEnvironmentRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.StopDevEnvironmentResponse.ReadOnly
            ] = proxy(StopDevEnvironment, request)
            def getSubscription(request: GetSubscriptionRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetSubscriptionResponse.ReadOnly
            ] = proxy(GetSubscription, request)
            def listProjects(request: ListProjectsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.ProjectSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProjects, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProjectsPaginated(request: ListProjectsRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListProjectsResponse.ReadOnly
            ] = proxy(ListProjectsPaginated, request)
            def listSpaces(request: ListSpacesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.SpaceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSpaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSpacesPaginated(request: ListSpacesRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListSpacesResponse.ReadOnly
            ] = proxy(ListSpacesPaginated, request)
            def createProject(request: CreateProjectRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.CreateProjectResponse.ReadOnly
            ] = proxy(CreateProject, request)
            def createSourceRepositoryBranch(
                request: CreateSourceRepositoryBranchRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.CreateSourceRepositoryBranchResponse.ReadOnly
            ] = proxy(CreateSourceRepositoryBranch, request)
            def deleteAccessToken(request: DeleteAccessTokenRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.DeleteAccessTokenResponse.ReadOnly
            ] = proxy(DeleteAccessToken, request)
            def verifySession(): IO[
              AwsError,
              zio.aws.codecatalyst.model.VerifySessionResponse.ReadOnly
            ] = proxy(VerifySession)
            def getSourceRepositoryCloneUrls(
                request: GetSourceRepositoryCloneUrlsRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetSourceRepositoryCloneUrlsResponse.ReadOnly
            ] = proxy(GetSourceRepositoryCloneUrls, request)
            def getUserDetails(request: GetUserDetailsRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetUserDetailsResponse.ReadOnly
            ] = proxy(GetUserDetails, request)
            def getSpace(request: GetSpaceRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.GetSpaceResponse.ReadOnly
            ] = proxy(GetSpace, request)
            def deleteDevEnvironment(request: DeleteDevEnvironmentRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.DeleteDevEnvironmentResponse.ReadOnly
            ] = proxy(DeleteDevEnvironment, request)
            def updateSpace(request: UpdateSpaceRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.UpdateSpaceResponse.ReadOnly
            ] = proxy(UpdateSpace, request)
            def listSourceRepositoryBranches(
                request: ListSourceRepositoryBranchesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.ListSourceRepositoryBranchesItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSourceRepositoryBranches, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSourceRepositoryBranchesPaginated(
                request: ListSourceRepositoryBranchesRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListSourceRepositoryBranchesResponse.ReadOnly
            ] = proxy(ListSourceRepositoryBranchesPaginated, request)
            def startDevEnvironment(
                request: StartDevEnvironmentRequest
            ): IO[AwsError, ReadOnly] = proxy(StartDevEnvironment, request)
            def listDevEnvironments(
                request: ListDevEnvironmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.codecatalyst.model.DevEnvironmentSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDevEnvironments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDevEnvironmentsPaginated(
                request: ListDevEnvironmentsRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.ListDevEnvironmentsResponse.ReadOnly
            ] = proxy(ListDevEnvironmentsPaginated, request)
            def deleteSpace(request: DeleteSpaceRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.DeleteSpaceResponse.ReadOnly
            ] = proxy(DeleteSpace, request)
            def startDevEnvironmentSession(
                request: StartDevEnvironmentSessionRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.StartDevEnvironmentSessionResponse.ReadOnly
            ] = proxy(StartDevEnvironmentSession, request)
            def deleteProject(request: DeleteProjectRequest): IO[
              AwsError,
              zio.aws.codecatalyst.model.DeleteProjectResponse.ReadOnly
            ] = proxy(DeleteProject, request)
            def createSourceRepository(
                request: CreateSourceRepositoryRequest
            ): IO[
              AwsError,
              zio.aws.codecatalyst.model.CreateSourceRepositoryResponse.ReadOnly
            ] = proxy(CreateSourceRepository, request)
          }
        }
      }
    }
  }
}
